﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Microsoft.Extensions.Configuration;
using Farakonesh.Logic.IDatabase;
using Farakonesh.Logic.IServices.IRestRequest;
using Farakonesh.Logic.Log;
using Farakonesh.Logic.Services.Cache;
using Farakonesh.Models.Database.StoredProcedures.App.dbo;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.dbo
{
    /// <summary>
    /// سرویس های کار با کش های سیستم
    /// </summary>
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class SystemCacheController : ControllerBase
    {
        private readonly RedisService _redisService;
        private readonly IHttpRequestArvanCloud _httpRequestArvanCloud;
        public SystemCacheController(RedisService redisService,
            IHttpRequestArvanCloud httpRequestArvanCloud)
        {
            _redisService = redisService;
            _httpRequestArvanCloud = httpRequestArvanCloud;
        }
        /// <summary>
        /// پاک کردن کش مربوط به دیتابیس ردیس
        /// </summary>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> ClearRedis(CancellationToken cancellationToken)
        {
            var rst = await _redisService.Clear();
            return Ok(rst);
        }
        /// <summary>
        /// پاک کردن کش مربوط به سی دی ان آروان کلود
        /// </summary>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> ClearArvanCDN(CancellationToken cancellationToken)
        {
            var rst = await _httpRequestArvanCloud.clearCache(cancellationToken);
            return Ok(rst);
        }
    }
}
