﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.API.Filters;
using Farakonesh.Logic.IDatabase;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Models.Database.StoredProcedures.App.dbo;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.tag;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.dbo
{
    /// <summary>
    /// سرویس های کار با برچسب های سیستم
    /// </summary>
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class TagController : ControllerBase
    {
        private readonly ITagContext _ctx;

        public TagController(
    ITagContext ctx)
        {
            _ctx = ctx;
        }
        /// <summary>
        /// دریافت لیست برچسب ها
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetAll([FromBody] Get_Tag.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Get_Tag(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ثبت یک برچسب جدید و انتصاب آن به منو
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> SaveTagMenu([FromBody] Insert_Tag_Menus.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_Tag_Menus(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ثبت گروهی برچسب ها برای یک منو
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> SaveTagMenuGroup([FromBody] Insert_Tag_MenusGroup.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_Tag_MenusGroup(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// حذف یک برچسب
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpDelete]
        public async Task<IActionResult> Delete([FromQuery] Delete_Tag.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Delete_Tag(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
