﻿using Farakonesh.API.Filters;
using Farakonesh.Logic.IServices.IRestRequest;
using Farakonesh.Models.Database;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using System.Threading.Tasks;
using System.Threading;
using Farakonesh.Models.API.Telegram;

namespace Farakonesh.API.Controllers.App.dbo
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class TelegramController : ControllerBase
    {
        private readonly IHttpRequestTelegram _httpRequestTelegram;
        public TelegramController(IHttpRequestTelegram httpRequestTelegram)
        {
            _httpRequestTelegram = httpRequestTelegram;
        }

        [HttpGet]
        public async Task<IActionResult> GetInfoBot(CancellationToken cancellationToken)
        {

            var response = await _httpRequestTelegram.GetInfoBot(cancellationToken);

            return Ok(response);
        }

        [HttpGet]
        public async Task<IActionResult> GetInfoChat([FromQuery] string chatId,CancellationToken cancellationToken)
        {

            var response = await _httpRequestTelegram.GetInfoChat(chatId, cancellationToken);

            return Ok(response);
        }

        [HttpGet]
        public async Task<IActionResult> GetHookBot(CancellationToken cancellationToken)
        {

            var response = await _httpRequestTelegram.GetHookBot(cancellationToken);

            return Ok(response);
        }

        [HttpDelete]
        public async Task<IActionResult> DeleteHookBot(CancellationToken cancellationToken)
        {

            var response = await _httpRequestTelegram.DeleteHookBot(cancellationToken);

            return Ok(response);
        }

        [HttpPost]
        public async Task<IActionResult> SetHookBot([FromBody] RequestSetHookToBotTelegramModel command, CancellationToken cancellationToken)
        {

            var response = await _httpRequestTelegram.SetHookBot(command, cancellationToken);

            return Ok(response);
        }
        [HttpGet]
        public async Task<IActionResult> LeaveChannel([FromQuery] string chatId, CancellationToken cancellationToken)
        {

            var response = await _httpRequestTelegram.LeaveChat(chatId, cancellationToken);

            return Ok(response);
        }
        [HttpGet]
        public async Task<IActionResult> GetMemberCount([FromQuery] string chatId, CancellationToken cancellationToken)
        {

            var response = await _httpRequestTelegram.GetMemberCount(chatId, cancellationToken);

            return Ok(response);
        }
        [HttpGet]
        public async Task<IActionResult> GetAdministrators([FromQuery] string chatId, CancellationToken cancellationToken)
        {

            var response = await _httpRequestTelegram.GetAdministrators(chatId, cancellationToken);

            return Ok(response);
        }
    }
}
