﻿using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.tag;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using System.Threading.Tasks;
using System.Threading;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.versionHistory;

namespace Farakonesh.API.Controllers.App.dbo
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class VersionController : ControllerBase
    {
        private readonly IVersionContext _ctx;

        public VersionController(
    IVersionContext ctx)
        {
            _ctx = ctx;
        }
        /// <summary>
        /// دریافت سابقه نسخه گذاری - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetAll([FromBody] Get_VersionHistory.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Get_VersionHistory(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ثبت سابقه نسخه گذاری - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> Save([FromBody] Insert_VersionHistory.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_VersionHistory(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// بروز رسانی سابقه نسخه گذاری - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> Update([FromBody] Update_VersionHistory.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Update_VersionHistory(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// حذف سابقه نسخه گذاری - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpDelete]
        public async Task<IActionResult> Delete([FromQuery] Delete_VersionHistory.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Delete_VersionHistory(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
