﻿using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using NSwag.Annotations;
using Farakonesh.Logic.CommonOperations;
using Farakonesh.Logic.IDatabase;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.IDatabase.IQueue;
using Farakonesh.Logic.IServices.IApp.IUser;
using Farakonesh.Logic.Services.App;
using Farakonesh.Logic.Services.Cache;
using Farakonesh.Models.API.Goftino;
using Farakonesh.Models.Database.StoredProcedures.App.dbo;
using System.Collections.Generic;
using System.Net;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.Hook
{
    /// <summary>
    /// هوک های متصل به گفتینو
    /// </summary>
    [Route("api/WebHook/[controller]/[action]")]
    [ApiController]
    public class GoftinoController : ControllerBase
    {
        private readonly IChatService  _chatService;
        public GoftinoController(IChatService chatService)
        {
            _chatService = chatService;
        }
        /// <summary>
        /// رویداد دریافت اطلاعات گفتگوی جدید از گفتینو
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPost]
        [AllowAnonymous]
        public async Task<IActionResult> EventMessage([FromBody] ResponseWebHookMessage command,CancellationToken cancellationToken)
        {
            var response =  await _chatService.saveEvent(command, cancellationToken);
            return Ok(response);
        }
    }
}
