﻿using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.Logic.IServices.IApp.IUser;
using Farakonesh.Models.API.Goftino;
using System.Threading.Tasks;
using System.Threading;
using Farakonesh.Logic.Log;
using Farakonesh.Models.API.Nipoto.Creating.Response;
using Farakonesh.Logic.IServices.IApp.ICryptoCurrency;

namespace Farakonesh.API.Controllers.Hook
{
    [Route("api/WebHook/[controller]/[action]")]
    [ApiController]
    public class NipotoController : ControllerBase
    {
        private readonly ILog _log;
        private readonly INipotoService _nipotoService;
        public NipotoController(ILog log, INipotoService nipotoService)
        {
            _log = log;
            _nipotoService= nipotoService;
        }
        /// <summary>
        /// رویداد دریافت شناسه واریز از نیپوتو
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPost]
        [AllowAnonymous]
        public async Task<IActionResult> Deposit([FromBody] ResponseWebHookDepositNipotoMessage command, CancellationToken cancellationToken)
        {
            await _nipotoService.getPayByDeposit(command.depositID, cancellationToken);
            return Ok();
        }
    }
}
