﻿using Farakonesh.Logic.ICommonOperations;
using Farakonesh.Logic.IDatabase.IQueue;
using Farakonesh.Logic.IServices.IApp.ICryptoCurrency;
using Farakonesh.Logic.Log;
using Farakonesh.Logic.Services.App.CryptoCurrency;
using Farakonesh.Models.API.Nipoto.Creating.Response;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using System.Threading.Tasks;
using System.Threading;
using Farakonesh.Models.API.Whatsapp;
using Farakonesh.Logic.CommonOperations;
using Farakonesh.Models.Database.StoredProcedures.App.Queue;
using Kavenegar.Models.Enums;
using Farakonesh.Shared.Enums;

namespace Farakonesh.API.Controllers.Hook
{
    [Route("api/WebHook/[controller]/[action]")]
    [ApiController]
    public class WhatsappController : ControllerBase
    {
        private readonly ILog _log;
        private readonly IQueueContext _queueContext;
        public WhatsappController(ILog log, IQueueContext queueContext)
        {
            _log = log;
            _queueContext = queueContext;
        }
        [HttpPost]
        [AllowAnonymous]
        public async Task<IActionResult> EventMessage([FromBody] ResponseWebHookWhatsappMessage command, CancellationToken cancellationToken)
        {
            if (command!=null && command.type == "message")
            {
                await _queueContext.Insert_MessengersByHook(new Insert_MessengersByHook.Inputs
                {
                    Address = "Event-" + command.data.from,
                    MessageId = command.data.id,
                    MessengerType = (int)MessengerType.Whatsapp,
                    Text = command.data.body
                }, cancellationToken);
            }
            return Ok();
        }
    }
}
