﻿using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.IDatabaseLog;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.blackList;
using Farakonesh.Models.Database.StoredProcedures.LogServer;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.LogServer
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class LogServerController : ControllerBase
    {
        private readonly ILogContext _ctx;
        public LogServerController(
        ILogContext ctx)
        {
            _ctx = ctx;
        }
        /// <summary>
        /// دریافت لیست لاگ های سمت سرور
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> Get([FromBody] SP_Log_GetAll.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.SP_Log_GetAll(inputs,cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت تعداد کل از هر نوع لاگ
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetCount([FromBody] SP_Log_Count.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.SP_Log_Count(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
