﻿using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.setting;
using Farakonesh.Models.Database.StoredProcedures.App.Order.ApplicationFee;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Payeer;
using Farakonesh.Models.Servant.Order;
using System.Threading;
using System.Threading.Tasks;
using Farakonesh.API.Filters;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Swift;

namespace Farakonesh.API.Controllers.Servant.Order
{
    [Route("api/servant/[controller]/[action]")]
    [ApiController]
    public class ApplicationFeeController : ControllerBase
    {
        private readonly IPublicContext _ctx;
        private readonly IApplicationFeeContext _ctxApplicationFeeContext;
        public ApplicationFeeController(
IPublicContext ctx, IApplicationFeeContext ctxApplicationFeeContext)
        {
            _ctx = ctx;
            _ctxApplicationFeeContext = ctxApplicationFeeContext;
        }
        [HttpGet]
        [AllowAnonymous]
        public async Task<IActionResult> PriceApplicationFee([FromQuery] InquiryPriceApplicationFeeType inputs, CancellationToken cancellationToken)
        {
            await _ctx.Check_IpAccess(new Check_IpAccess.Inputs { AccessKey = inputs.AccessKey, ServiceType = 551 }, cancellationToken);
            var rst = await _ctxApplicationFeeContext.Get_OrderApplicationFee_Price_Servant(new 
                Get_OrderApplicationFee_Price_Servant.Inputs { Amount = inputs.Amount, 
                CurrencyId = inputs.CurrencyId,ApplicationFeeType = inputs.ApplicationFeeType,
                ModuleType = inputs.ModuleType
            },cancellationToken);
            return Ok(rst);
        }
        [HttpGet]
        [AllowAnonymous]
        [CheckServiceKey]
        public async Task<IActionResult> PriceApplicationFeeTelegram([FromQuery] InquiryPriceApplicationFeeType inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctxApplicationFeeContext.Get_OrderApplicationFee_Price_Servant(new
                Get_OrderApplicationFee_Price_Servant.Inputs
            {
                Amount = inputs.Amount,
                CurrencyId = inputs.CurrencyId,
                ApplicationFeeType = inputs.ApplicationFeeType,
                ModuleType = inputs.ModuleType
            }, cancellationToken);
            return Ok(rst);
        }
    }
}
