﻿using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.Logic.Database.Order;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.setting;
using Farakonesh.Models.Database.StoredProcedures.App.Order;
using Farakonesh.Models.Servant.Order;
using System.Threading;
using System.Threading.Tasks;
using Farakonesh.Logic.IServices.ICache;
using Farakonesh.Models.Database;

namespace Farakonesh.API.Controllers.Servant.Order
{
    [Route("api/servant/[controller]/[action]")]
    [ApiController]
    public class CountryController : ControllerBase
    {
        private readonly IPublicContext _ctx;
        private readonly IRedisContextService _redisContextService;
        public CountryController(
IPublicContext ctx, IRedisContextService redisContextService)
        {
            _ctx = ctx;
            _redisContextService = redisContextService;
        }
        [HttpGet]
        [AllowAnonymous]
        public async Task<IActionResult> GetAll([FromQuery] string AccessKey, CancellationToken cancellationToken)
        {
            await _ctx.Check_IpAccess(new Check_IpAccess.Inputs { AccessKey = AccessKey, ServiceType = 551 }, cancellationToken);
            var rst = await _redisContextService.GetCountryListAsync(new GetCountryList.Inputs { },cancellationToken);
            return Ok(new DBResult() { Data = rst });
        }
    }
}
