﻿using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.setting;
using Farakonesh.Models.Servant.Order;
using System.Threading;
using System.Threading.Tasks;
using Farakonesh.Models.Database.StoredProcedures.App.Order;

namespace Farakonesh.API.Controllers.Servant.Order
{
    [Route("api/servant/[controller]/[action]")]
    [ApiController]
    public class CurrencyAmountController : ControllerBase
    {
        private readonly IPublicContext _ctx;
        private readonly ICurrencyContext _ctxCurrency;
        public CurrencyAmountController(
IPublicContext ctx, ICurrencyContext ctxCurrency)
        {
            _ctx = ctx;
            _ctxCurrency = ctxCurrency;
        }
        /// <summary>
        /// دریافت لیست ارز به همراه قیمت بروز شده - بصورت عمومی
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpGet]
        [AllowAnonymous]
        public async Task<IActionResult> GetAll([FromQuery] CurrencyAmount inputs, CancellationToken cancellationToken)
        {
            await _ctx.Check_IpAccess(new Check_IpAccess.Inputs {AccessKey=inputs.AccessKey,ServiceType = 551 }, cancellationToken);
            var rst = await _ctxCurrency.GetCurrencyAmountList_Servant(new GetCurrencyAmountList_Servant.Inputs { 
                CurrencyId = inputs.CurrencyId
                ,OrderType=inputs.OrderType,ShowInMessagingTelegram = inputs.ShowInMessagingTelegram}, cancellationToken);
            return Ok(rst);
        }
    }
}
