﻿using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.setting;
using Farakonesh.Models.Servant.Order;
using System.Threading;
using System.Threading.Tasks;
using Farakonesh.API.Filters;
using Farakonesh.Models.Database.StoredProcedures.App.Order;
using Farakonesh.Logic.IServices.ICache;
using Farakonesh.Models.Database;

namespace Farakonesh.API.Controllers.Servant.Order
{
    [Route("api/servant/[controller]/[action]")]
    [ApiController]
    public class CurrencyController : ControllerBase
    {
        private readonly IPublicContext _ctx;
        private readonly IRedisContextService _redisContextService;
        public CurrencyController(
IPublicContext ctx,IRedisContextService redisContextService)
        {
            _redisContextService = redisContextService;
            _ctx = ctx;
        }
        /// <summary>
        /// دریافت لیست ارز ها - بصورت عمومی
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpGet]
        [AllowAnonymous]
        public async Task<IActionResult> GetAll([FromQuery] Currency inputs, CancellationToken cancellationToken)
        {
            await _ctx.Check_IpAccess(new Check_IpAccess.Inputs { AccessKey = inputs.AccessKey, ServiceType = 551 }, cancellationToken);
            var rst = await _redisContextService.GetCurrencyListServantAsync(new GetCurrencyList_Servant.Inputs { 
                OrderType = inputs.OrderType
            }, cancellationToken);
            return Ok(new DBResult() { Data = rst });
        }

    }
}
