﻿using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Logic.IServices.ICache;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.setting;
using Farakonesh.Models.Database.StoredProcedures.App.Order;
using Farakonesh.Models.Database.StoredProcedures.App.Order.IncomeCashExchange;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Payeer;
using Farakonesh.Models.Servant.Order;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.Servant.Order
{
    [Route("api/servant/[controller]/[action]")]
    [ApiController]
    public class IncomeCashExchangeController : ControllerBase
    {
        private readonly IIncomeCashExchangeContext _incomeCashExchangeContext;
        private readonly IPublicContext _ctx;
        public IncomeCashExchangeController(
IIncomeCashExchangeContext incomeCashExchangeContext, IPublicContext ctx)
        {
            _incomeCashExchangeContext = incomeCashExchangeContext;
            _ctx = ctx;
        }
        /// <summary>
        /// استعلام قیمت فروش - عمومی
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpGet]
        [AllowAnonymous]
        public async Task<IActionResult> IncomeCashExchange([FromQuery] InquiryPriceOrder inputs, CancellationToken cancellationToken)
        {

            await _ctx.Check_IpAccess(new Check_IpAccess.Inputs { AccessKey = inputs.AccessKey, ServiceType = 551 }, cancellationToken);
            
            var rst = await _incomeCashExchangeContext.Get_OrderIncomeCashExchange_Price_Servant(new Get_OrderIncomeCashExchange_Price_Servant.Inputs
            {
                Amount = inputs.Amount,
                CurrencyId = inputs.CurrencyId,
                ModuleType = inputs.ModuleType,
                OrderType = inputs.OrderType
            }, cancellationToken);

            return Ok(rst);
        }
    }
}
