﻿using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Models.Database.StoredProcedures.App.Order.PerfectMoney;
using Farakonesh.Models.Servant.Order;
using System.Threading.Tasks;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Payeer;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.setting;
using Farakonesh.Logic.IDatabase.idbo;
using System.Threading;
using Farakonesh.API.Filters;

namespace Farakonesh.API.Controllers.Servant.Order
{
    /// <summary>
    /// سرویس های استعلام قیمت خدمات پایر
    /// </summary>
    [Route("api/servant/[controller]/[action]")]
    [ApiController]
    public class PayeerController : ControllerBase
    {
        private readonly IPublicContext _ctx;
        private readonly IPayeerContext _ctxPayeerContext;
        public PayeerController(
IPublicContext ctx, IPayeerContext ctxPayeerContext)
        {
            _ctx = ctx;
            _ctxPayeerContext = ctxPayeerContext;
        }
        [HttpGet]
        [AllowAnonymous]
        public async Task<IActionResult> PricePayeerCharge([FromQuery] InquiryPriceOrder inputs, CancellationToken cancellationToken)
        {
            await _ctx.Check_IpAccess(new Check_IpAccess.Inputs { AccessKey = inputs.AccessKey, ServiceType = 551 }, cancellationToken);
            var rst = await _ctxPayeerContext.Get_OrderPayerAccountCharge_Price_Servant(new Get_OrderPayerAccountCharge_Price_Servant.Inputs { 
                Amount = inputs.Amount, CurrencyId = inputs.CurrencyId,
                ModuleType = inputs.ModuleType
            }, cancellationToken);
            return Ok(rst);
        }
        [HttpGet]
        [AllowAnonymous]
        [CheckServiceKey]
        public async Task<IActionResult> PricePayeerChargeTelegram([FromQuery] InquiryPriceOrder inputs, CancellationToken cancellationToken)
        {
           var rst = await _ctxPayeerContext.Get_OrderPayerAccountCharge_Price_Servant(new Get_OrderPayerAccountCharge_Price_Servant.Inputs
            {
                Amount = inputs.Amount,
                CurrencyId = inputs.CurrencyId,
                ModuleType = inputs.ModuleType
            }, cancellationToken);
            return Ok(rst);
        }
        [HttpGet]
        [AllowAnonymous]
        public async Task<IActionResult> PricePayeerSell([FromQuery] InquiryPriceOrder inputs, CancellationToken cancellationToken)
        {
            await _ctx.Check_IpAccess(new Check_IpAccess.Inputs { AccessKey = inputs.AccessKey, ServiceType = 551 }, cancellationToken);
            var rst = await _ctxPayeerContext.Get_OrderPayeerSell_Price_Servant(new Get_OrderPayeerSell_Price_Servant.Inputs { Amount = inputs.Amount
                , CurrencyId = inputs.CurrencyId,
                ModuleType = inputs.ModuleType
            }, cancellationToken);
            return Ok(rst);
        }
        [HttpGet]
        [AllowAnonymous]
        [CheckServiceKey]
        public async Task<IActionResult> PricePayeerSellTelegram([FromQuery] InquiryPriceOrder inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctxPayeerContext.Get_OrderPayeerSell_Price_Servant(new Get_OrderPayeerSell_Price_Servant.Inputs
            {
                Amount = inputs.Amount
                ,
                CurrencyId = inputs.CurrencyId,
                ModuleType = inputs.ModuleType
            }, cancellationToken);
            return Ok(rst);
        }
    }
}
