﻿using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Paypal;
using Farakonesh.Models.Servant.Order;
using System.Threading.Tasks;
using Farakonesh.Models.Database.StoredProcedures.App.Order.PaymentInternationalSites;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.setting;
using Farakonesh.Logic.IDatabase.idbo;
using System.Threading;
using Farakonesh.API.Filters;

namespace Farakonesh.API.Controllers.Servant.Order
{
    /// <summary>
    /// سرویس های استعلام قیمت خدمات پرداخت در سایت های خارجی
    /// </summary>
    [Route("api/servant/[controller]/[action]")]
    [ApiController]
    public class PaymentInternationalSitesController : ControllerBase
    {
        private readonly IPublicContext _ctx;
        private readonly IPaymentInternationalSitesContext _ctxOrder;
        public PaymentInternationalSitesController(
IPublicContext ctx, IPaymentInternationalSitesContext ctxOrder)
        {
            _ctx = ctx;
            _ctxOrder = ctxOrder;
        }
        /// <summary>
        /// استعلام قیمت پرداخت در سایت های خارجی - سمت سایت اصلی
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpGet]
        [AllowAnonymous]
        public async Task<IActionResult> PricePaymentInternationalSites([FromQuery] InquiryPriceOrderType inputs, CancellationToken cancellationToken)
        {
            await _ctx.Check_IpAccess(new Check_IpAccess.Inputs { AccessKey = inputs.AccessKey, ServiceType = 551 }, cancellationToken);
            var rst = await _ctxOrder.Get_OrderPaymentInternationalSites_Price_Servant(new Get_OrderPaymentInternationalSites_Price_Servant.Inputs { Amount = inputs.Amount
                , CurrencyId = inputs.CurrencyId,OrderType = inputs.OrderType,
                ModuleType = inputs.ModuleType
            }, cancellationToken);
            return Ok(rst);
        }

        [HttpGet]
        [AllowAnonymous]
        [CheckServiceKey]
        public async Task<IActionResult> PricePaymentInternationalSitesTelegram([FromQuery] InquiryPriceOrderType inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctxOrder.Get_OrderPaymentInternationalSites_Price_Servant(new Get_OrderPaymentInternationalSites_Price_Servant.Inputs
            {
                Amount = inputs.Amount,
                CurrencyId = inputs.CurrencyId,
                OrderType = inputs.OrderType,
                ModuleType = inputs.ModuleType
            }, cancellationToken);
            return Ok(rst);
        }

    }
}
