﻿using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Models.Database.StoredProcedures.App.Order.PerfectMoney;
using Farakonesh.Models.Servant.Order;
using System.Threading.Tasks;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Paypal;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.setting;
using Farakonesh.Logic.IDatabase.idbo;
using System.Threading;
using Farakonesh.API.Filters;

namespace Farakonesh.API.Controllers.Servant.Order
{
    /// <summary>
    /// سرویس های استعلام قیمت خدمات پی پال
    /// </summary>
    [Route("api/servant/[controller]/[action]")]
    [ApiController]
    public class PaypalController : ControllerBase
    {
        private readonly IPublicContext _ctx;
        private readonly IPaypalContext _ctxPaypal;
        public PaypalController(
IPublicContext ctx, IPaypalContext ctxPaypal)
        {
            _ctx = ctx;
            _ctxPaypal = ctxPaypal;
        }
        /// <summary>
        /// استعلام قیمت خرید با پی پال - سمت وب سایت اصلی
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpGet]
        [AllowAnonymous]
        public async Task<IActionResult> PricePaypalBuy([FromQuery] InquiryPriceOrder inputs, CancellationToken cancellationToken)
        {
            await _ctx.Check_IpAccess(new Check_IpAccess.Inputs { AccessKey = inputs.AccessKey, ServiceType = 551 }, cancellationToken);
            var rst = await _ctxPaypal.Get_OrderPaypalBuy_Price_Servant(new Get_OrderPaypalBuy_Price_Servant.Inputs { 
                Amount = inputs.Amount, CurrencyId = inputs.CurrencyId,
                ModuleType = inputs.ModuleType
            }, cancellationToken);
            return Ok(rst);
        }
        [HttpGet]
        [AllowAnonymous]
        [CheckServiceKey]
        public async Task<IActionResult> PricePaypalBuyTelegram([FromQuery] InquiryPriceOrder inputs, CancellationToken cancellationToken)
        {
           var rst = await _ctxPaypal.Get_OrderPaypalBuy_Price_Servant(new Get_OrderPaypalBuy_Price_Servant.Inputs
            {
                Amount = inputs.Amount,
                CurrencyId = inputs.CurrencyId,
                ModuleType = inputs.ModuleType
            }, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// استعلام قیمت شارژ پی پال - سمت وب سایت اصلی
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpGet]
        [AllowAnonymous]
        public async Task<IActionResult> PricePaypalCharge([FromQuery] InquiryPriceOrder inputs, CancellationToken cancellationToken)
        {
            await _ctx.Check_IpAccess(new Check_IpAccess.Inputs { AccessKey = inputs.AccessKey, ServiceType = 551 }, cancellationToken);
            var rst = await _ctxPaypal.Get_OrderPaypalCharge_Price_Servant(new Get_OrderPaypalCharge_Price_Servant.Inputs { 
                Amount = inputs.Amount, CurrencyId = inputs.CurrencyId,
                ModuleType = inputs.ModuleType
            }, cancellationToken);
            return Ok(rst);
        }
        [HttpGet]
        [AllowAnonymous]
        [CheckServiceKey]
        public async Task<IActionResult> PricePaypalChargeTelegram([FromQuery] InquiryPriceOrder inputs, CancellationToken cancellationToken)
        {
           var rst = await _ctxPaypal.Get_OrderPaypalCharge_Price_Servant(new Get_OrderPaypalCharge_Price_Servant.Inputs
            {
                Amount = inputs.Amount,
                CurrencyId = inputs.CurrencyId,
                ModuleType = inputs.ModuleType
            }, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// استعلام قیمت فروش پی پال - سمت وب سایت اصلی
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpGet]
        [AllowAnonymous]
        public async Task<IActionResult> PricePaypalSell([FromQuery] InquiryPriceOrder inputs, CancellationToken cancellationToken)
        {
            await _ctx.Check_IpAccess(new Check_IpAccess.Inputs { AccessKey = inputs.AccessKey, ServiceType = 551 }, cancellationToken);
            var rst = await _ctxPaypal.Get_OrderPaypalSell_Price_Servant(new Get_OrderPaypalSell_Price_Servant.Inputs {
                Amount = inputs.Amount, CurrencyId = inputs.CurrencyId,
                ModuleType = inputs.ModuleType
            }, cancellationToken);
            return Ok(rst);
        }
        [HttpGet]
        [AllowAnonymous]
        [CheckServiceKey]
        public async Task<IActionResult> PricePaypalSellTelegram([FromQuery] InquiryPriceOrder inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctxPaypal.Get_OrderPaypalSell_Price_Servant(new Get_OrderPaypalSell_Price_Servant.Inputs
            {
                Amount = inputs.Amount,
                CurrencyId = inputs.CurrencyId,
                ModuleType = inputs.ModuleType
            }, cancellationToken);
            return Ok(rst);
        }
    }
}
