﻿using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.setting;
using Farakonesh.Models.Database.StoredProcedures.App.Order.PerfectMoney;
using Farakonesh.Models.Servant.Order;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.Servant.Order
{
    /// <summary>
    /// سرویس های استعلام قیمت خدمات پرفکت مانی
    /// </summary>
    [Route("api/servant/[controller]/[action]")]
    [ApiController]
    public class PerfectMoneyController : ControllerBase
    {
        private readonly IPublicContext _ctx;
        private readonly IPerfectMoneyContext _ctxPerfectMoney;
        public PerfectMoneyController(
IPublicContext ctx, IPerfectMoneyContext ctxPerfectMoney)
        {
            _ctx = ctx;
            _ctxPerfectMoney = ctxPerfectMoney;
        }
        [HttpGet]
        [AllowAnonymous]
        public async Task<IActionResult> PricePerfectMoneyCharge([FromQuery] InquiryPriceOrder inputs, CancellationToken cancellationToken)
        {
            await _ctx.Check_IpAccess(new Check_IpAccess.Inputs { AccessKey = inputs.AccessKey, ServiceType = 551 }, cancellationToken);
            var rst = await _ctxPerfectMoney.Get_OrderPerfectMoneyCharge_Price_Servant(new Get_OrderPerfectMoneyCharge_Price_Servant.Inputs { Amount = inputs.Amount,CurrencyId = inputs.CurrencyId,
                ModuleType = inputs.ModuleType
            }, cancellationToken);
            return Ok(rst);
        }
        [HttpGet]
        [AllowAnonymous]
        public async Task<IActionResult> PriceVoucherPerfectMoney([FromQuery] InquiryPriceOrder inputs, CancellationToken cancellationToken)
        {
            await _ctx.Check_IpAccess(new Check_IpAccess.Inputs { AccessKey = inputs.AccessKey, ServiceType = 551 }, cancellationToken);
            var rst = await _ctxPerfectMoney.Get_OrderPerfectMoneyVoucher_Price_Servant(new Get_OrderPerfectMoneyVoucher_Price_Servant.Inputs { Amount = inputs.Amount,
                CurrencyId = inputs.CurrencyId,
                ModuleType = inputs.ModuleType
            }, cancellationToken);
            return Ok(rst);
        }
    }
}
