﻿using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.setting;
using Farakonesh.Models.Database.StoredProcedures.App.Order.SendRemittanceToIran;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Swift;
using Farakonesh.Models.Servant.Order;
using System.Threading;
using System.Threading.Tasks;
using Farakonesh.API.Filters;

namespace Farakonesh.API.Controllers.Servant.Order
{
    [Route("api/servant/[controller]/[action]")]
    [ApiController]
    public class SendRemittanceToIranController : ControllerBase
    {
        private readonly IPublicContext _ctx;
        private readonly ISendRemittanceToIranCotext _ctxSendRemittanceToIranContext;
        public SendRemittanceToIranController(
IPublicContext ctx, ISendRemittanceToIranCotext ctxSendRemittanceToIranContext)
        {
            _ctx = ctx;
            _ctxSendRemittanceToIranContext = ctxSendRemittanceToIranContext;
        }
        [HttpGet]
        [AllowAnonymous]
        public async Task<IActionResult> PriceSendRemittanceToIran([FromQuery] InquiryPriceSwiftTransfer inputs, CancellationToken cancellationToken)
        {
            await _ctx.Check_IpAccess(new Check_IpAccess.Inputs { AccessKey = inputs.AccessKey, ServiceType = 551 }, cancellationToken);
            var rst = await _ctxSendRemittanceToIranContext.Get_OrderSendRemittanceToIran_Price_Servant(new Get_OrderSendRemittanceToIran_Price_Servant.Inputs
            { Amount = inputs.Amount, CurrencyId = inputs.CurrencyId, CountryId = inputs.CountryId,
            ModuleType = inputs.ModuleType }, cancellationToken);
            return Ok(rst);
        }
        [HttpGet]
        [AllowAnonymous]
        [CheckServiceKey]
        public async Task<IActionResult> PriceSendRemittanceToIranTelegram([FromQuery] InquiryPriceSwiftTransfer inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctxSendRemittanceToIranContext.Get_OrderSendRemittanceToIran_Price_Servant(new Get_OrderSendRemittanceToIran_Price_Servant.Inputs
            { Amount = inputs.Amount, CurrencyId = inputs.CurrencyId
            , CountryId = inputs.CountryId,ModuleType = inputs.ModuleType }, cancellationToken);
            return Ok(rst);
        }
    }
}
