﻿using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Paypal;
using Farakonesh.Models.Servant.Order;
using System.Threading.Tasks;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Wise;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.setting;
using Farakonesh.Logic.IDatabase.idbo;
using System.Threading;
using Farakonesh.API.Filters;

namespace Farakonesh.API.Controllers.Servant.Order
{
    /// <summary>
    /// سرویس های استعلام قیمت خدمات وایز
    /// </summary>
    [Route("api/servant/[controller]/[action]")]
    [ApiController]
    public class WiseController : ControllerBase
    {
        private readonly IPublicContext _ctx;
        private readonly IWiseContext _ctxWise;
        public WiseController(
IPublicContext ctx, IWiseContext ctxWise)
        {
            _ctx = ctx;
            _ctxWise = ctxWise;
        }
        /// <summary>
        /// دریافت قیمت بروز ثبت سفارش شارژ وایز
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpGet]
        [AllowAnonymous]
        public async Task<IActionResult> PriceWiseAccountCharge([FromQuery] InquiryPriceOrder inputs, CancellationToken cancellationToken)
        {
            await _ctx.Check_IpAccess(new Check_IpAccess.Inputs { AccessKey = inputs.AccessKey, ServiceType = 551 }, cancellationToken);
            var rst = await _ctxWise.Get_OrderWiseAccountCharge_Price_Servant(new 
                Get_OrderWiseAccountCharge_Price_Servant.Inputs { Amount = inputs.Amount, 
                CurrencyId = inputs.CurrencyId,
                ModuleType = inputs.ModuleType
            }, cancellationToken);
            return Ok(rst);
        }

        [HttpGet]
        [AllowAnonymous]
        [CheckServiceKey]
        public async Task<IActionResult> PriceWiseAccountChargeTelegram([FromQuery] InquiryPriceOrder inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctxWise.Get_OrderWiseAccountCharge_Price_Servant(new
                Get_OrderWiseAccountCharge_Price_Servant.Inputs
            {
                Amount = inputs.Amount,
                CurrencyId = inputs.CurrencyId,
                ModuleType = inputs.ModuleType
            }, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت قیمت بروز ثبت فروش وایز
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpGet]
        [AllowAnonymous]
        public async Task<IActionResult> PriceWiseSell([FromQuery] InquiryPriceOrder inputs, CancellationToken cancellationToken)
        {
            await _ctx.Check_IpAccess(new Check_IpAccess.Inputs { AccessKey = inputs.AccessKey, ServiceType = 551 },cancellationToken);
            var rst = await _ctxWise.Get_OrderWiseSell_Price_Servant(new Get_OrderWiseSell_Price_Servant.Inputs { 
                Amount = inputs.Amount, CurrencyId = inputs.CurrencyId,
                ModuleType = inputs.ModuleType
            }, cancellationToken);
            return Ok(rst);
        }
        [HttpGet]
        [AllowAnonymous]
        [CheckServiceKey]
        public async Task<IActionResult> PriceWiseSellTelegram([FromQuery] InquiryPriceOrder inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctxWise.Get_OrderWiseSell_Price_Servant(new Get_OrderWiseSell_Price_Servant.Inputs
            {
                Amount = inputs.Amount,
                CurrencyId = inputs.CurrencyId,
                ModuleType = inputs.ModuleType
            }, cancellationToken);
            return Ok(rst);
        }

    }
}
