﻿using Farakonesh.API.Filters;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Logic.IServices.ICache;
using Farakonesh.Models.Database.StoredProcedures.App.Order;
using Farakonesh.Models.Servant.Order;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using System.Threading.Tasks;
using System.Threading;
using Farakonesh.Logic.IDatabase.IQueue;
using Farakonesh.Models.Database.StoredProcedures.App.Queue;

namespace Farakonesh.API.Controllers.Servant.Telegram
{
    [Route("api/servant/[controller]/[action]")]
    [ApiController]
    public class TelegramBotChannelController : ControllerBase
    {
        private readonly IQueueContext _queueContext;

        public TelegramBotChannelController(IQueueContext queueContext)
        {
            _queueContext = queueContext;
        }
        
        [HttpPut]
        [AllowAnonymous]
        [CheckServiceKey]
        public async Task<IActionResult> Save([FromBody] Insert_TelegramBotChannelByHook.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _queueContext.Insert_TelegramBotChannelByHook(inputs, cancellationToken);
            return Ok(rst);
        }

        [HttpGet]
        [AllowAnonymous]
        [CheckServiceKey]
        public async Task<IActionResult> GetChatConnection([FromQuery] Get_TelegramBotChannelConnectionAction_WithoutToken.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _queueContext.Get_TelegramBotChannelConnectionAction_WithoutToken(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
