﻿using Farakonesh.API.Filters;
using Farakonesh.Models.Database.StoredProcedures.App.Order;
using Farakonesh.Models.Servant.Order;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using System.Threading.Tasks;
using System.Threading;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Logic.IServices.ICache;
using Farakonesh.Models.Database;

namespace Farakonesh.API.Controllers.Servant.Telegram
{
    [Route("api/servant/[controller]/[action]")]
    [ApiController]
    public class TelegramOrderController : ControllerBase
    {
        private readonly ICurrencyContext _ctxCurrency;
        private IRedisContextService _redisContextService;

        public TelegramOrderController(ICurrencyContext ctxCurrency, IRedisContextService redisContextService)
        {
            _ctxCurrency = ctxCurrency;
            _redisContextService = redisContextService;
        }
        [HttpPut]
        [AllowAnonymous]
        [CheckServiceKey]
        public async Task<IActionResult> GetReadyCurrencyForTelegram([FromBody] CurrencyAmount inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctxCurrency.GetCurrencyAmountList_Servant(new GetCurrencyAmountList_Servant.Inputs { OrderType = inputs.OrderType,
            CurrencyId = inputs.CurrencyId,
            ShowInMessagingTelegram = inputs.ShowInMessagingTelegram,
            }, cancellationToken);
            return Ok(rst);
        }
        [HttpPut]
        [AllowAnonymous]
        [CheckServiceKey]
        public async Task<IActionResult> GetAllCurrencyForTelegram([FromBody] Currency inputs, CancellationToken cancellationToken)
        {

            var rst = await _redisContextService.GetCurrencyListServantAsync(new GetCurrencyList_Servant.Inputs { OrderType = inputs.OrderType }, cancellationToken);
            return Ok(new DBResult() { Data = rst });
        }

    }
}
