﻿using Farakonesh.API.Filters;
using Farakonesh.Models.Database;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using System.Threading.Tasks;
using System.Threading;
using Farakonesh.Logic.IServices.ICache;

namespace Farakonesh.API.Controllers.Servant.Telegram
{
    [Route("api/servant/[controller]/[action]")]
    [ApiController]
    public class TelegramSettingController: ControllerBase
    {
        private readonly IRedisContextService _redisContextService;
        public TelegramSettingController(IRedisContextService redisContextService)
        {
            _redisContextService = redisContextService;
        }
        [HttpGet]
        [AllowAnonymous]
        [CheckServiceKey]
        public async Task<IActionResult> GetSettingForTelegram([FromQuery] int? moduleType,CancellationToken cancellationToken)
        {

            var rst = await _redisContextService.GetOrderSettingListWithoutTokenUseInTelegramAsync(moduleType, cancellationToken);
            return Ok(new DBResult { Data = rst });
        }
    }
}
