﻿using Farakonesh.API.Filters;
using Farakonesh.Commands.Services.User;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using System.Threading.Tasks;
using System.Threading;
using Farakonesh.Logic.IServices.IApp.IUser;
using Farakonesh.Models.API.Telegram;
using Farakonesh.Models.Database.StoredProcedures.App.Queue;
using System;
using Farakonesh.Logic.IDatabase.IQueue;

namespace Farakonesh.API.Controllers.Servant.Telegram
{
    [Route("api/servant/[controller]/[action]")]
    [ApiController]
    public class TelegramUserController : ControllerBase
    {
        private readonly IAuthServices _authServices;
        private readonly IQueueContext _queueContext;
        public TelegramUserController(IAuthServices authServices, IQueueContext queueContext)
        {
            _authServices = authServices;
            _queueContext = queueContext;
        }
        [HttpPost]
        [AllowAnonymous]
        [CheckServiceKey]
        public async Task<IActionResult> ConnectToMessenger([FromBody] ResponseWebHookTelegramMessage command, CancellationToken cancellationToken)
        {
            if (command.type == "start")
            {
                await _queueContext.Update_Connect_To_MessengersByCustomer(new Update_Connect_To_MessengersByCustomer.Inputs
                {
                    MessengerId = Guid.Parse(command.token),
                    ChatId = command.chatId
                }, cancellationToken);
            }

            return Ok();
        }
        /// <summary>
        /// حذف اتصال حساب کاربری از ربات تلگرام ، از طریق ربات تلگرام
        /// </summary>
        /// <param name="command"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpDelete]
        [AllowAnonymous]
        [CheckServiceKey]
        public async Task<IActionResult> DisconnectToMessenger([FromQuery] ResponseWebHookTelegramMessage command, CancellationToken cancellationToken)
        {
            if (command.type == "disconnect")
            {
                await _queueContext.Disconnect_To_MessengersByCustomer(new Disconnect_To_MessengersByCustomer.Inputs
                {
                    Token = null,
                    ChatId = command.chatId
                }, cancellationToken);
            }

            return Ok();
        }
        /// <summary>
        /// ارسال کد یکبار مصرف از طریق تلگرام
        /// </summary>
        /// <param name="command"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPost]
        [AllowAnonymous]
        [CheckServiceKey]
        public async Task<IActionResult> SendInTelegram([FromBody] SendCodeInTelegramCommand command, CancellationToken cancellationToken)
        {
            var rst = await _authServices.SendCodeInTelegram(command, cancellationToken);
            return Ok(rst);
        }
    }
}
