﻿using System.Security.Claims;

namespace Farakonesh.API.Extensions
{
    public static class User
    {
        private static string Get(ClaimsPrincipal user, string key)
        {
            if (user == null)
                return null;

            var item = user.FindFirst(key);
            if (item == null)
                return null;

            return item.Value;

        }

        public static string GetToken(this ClaimsPrincipal user)
        {
            if (user == null)
                return null;

            var item = user.Identity.Name;
            if (item == null)
                return null;

            return item;

        }

        public static string GetAccessPanel(this ClaimsPrincipal user)
        {
            return Get(user, "IsAccessAdmin");
        }

        public static string GetAccessCompanyPanel(this ClaimsPrincipal user)
        {
            return Get(user, "IsAccessCompanyPanel");
        }

    }
}
