﻿using Farakonesh.Shared.Helpers;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.Mvc.Filters;
using System;
using System.Linq;

namespace Farakonesh.API.Filters
{
    [AttributeUsage(AttributeTargets.Method | AttributeTargets.Class)]
    public class AllowOnlyIpAttribute : Attribute, IAuthorizationFilter
    {
        private readonly string[] _allowedIps;

        public AllowOnlyIpAttribute(params string[] allowedIps)
        {
            _allowedIps = allowedIps;
        }

        public void OnAuthorization(AuthorizationFilterContext context)
        {
            var httpContext = context.HttpContext;

            string clientIp = httpContext.Connection.RemoteIpAddress?.ToString();

            if (httpContext.Request.Headers.ContainsKey("X-Forwarded-For"))
            {
                clientIp = httpContext.Request.Headers["X-Forwarded-For"].FirstOrDefault()?.Split(',').First().Trim();
            }

            if (!_allowedIps.Contains(clientIp))
            {
                context.Result = new ContentResult()
                {
                    StatusCode = 403,
                    Content = MessageHelper.AccessDeniedIp403
                };
            }
        }
    }
}
