﻿using Farakonesh.Shared.Helpers;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.Mvc.Filters;
using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.DependencyInjection;
using System;
using System.Linq;

namespace Farakonesh.API.Filters
{
    public class AllowedIpsAttribute : ActionFilterAttribute
    {
        private readonly string _configKey;

        public AllowedIpsAttribute(string configKey)
        {
            _configKey = configKey;
        }

        public override void OnActionExecuting(ActionExecutingContext context)
        {
            var configuration = context.HttpContext.RequestServices.GetRequiredService<IConfiguration>();

            var allowedIps = configuration[_configKey]
                ?.Split(",", StringSplitOptions.RemoveEmptyEntries | StringSplitOptions.TrimEntries)
                ?? new string[0];

            var remoteIp = context.HttpContext.Connection.RemoteIpAddress?.ToString();

            if (!allowedIps.Contains(remoteIp))
            {
                context.Result = new ContentResult
                {
                    StatusCode = StatusCodes.Status403Forbidden,
                    Content = MessageHelper.AccessDeniedIp403
                };
                return;
            }

            base.OnActionExecuting(context);
        }
    }
}
