﻿
using Farakonesh.API.Extensions;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.Mvc.Filters;
using System;
using System.IO;
using System.Linq;
using System.Threading.Tasks;
using Newtonsoft.Json;
using System.Text;
using Farakonesh.Logic.CommonOperations;
using YamlDotNet.Core.Tokens;
using System.Net.Http;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.menu;

namespace Farakonesh.API.Filters
{
    public class AllowAnonymousCustomeAttribute : Attribute
    {
    }
    public class FormDataAuth : Attribute
    {
    }
    public class CustomersAuth : Attribute
    {
    }
    public class CompanyAuth : Attribute
    {
    }
    public class AuthAttribute : TypeFilterAttribute
    {
        public AuthAttribute() : base(typeof(AuthFilterImpl))
        {
        }
    }
   
    /// <summary>
    /// Authorization user request by checking JWT token from header
    /// </summary>
    public class AuthFilterImpl : IAsyncAuthorizationFilter
    {

        private readonly IMenusContext _menusContext;
        public AuthFilterImpl(IMenusContext menusContext)
        {
            _menusContext = menusContext;
        }
        /// <summary>
        /// Check user authorization by checking JWT token placed at header
        /// </summary>
        /// <param name="context"></param>
        public async Task OnAuthorizationAsync(AuthorizationFilterContext context)
        {
            var cancellationToken = context.HttpContext.RequestAborted;

            if (context.ActionDescriptor.EndpointMetadata.OfType<FormDataAuth>().Any())
                return;

            HttpRequest request = context.HttpContext.Request;
            Stream stream = request.Body;
            StreamReader originalReader = new StreamReader(stream);
            string originalContent = await originalReader.ReadToEndAsync();
            dynamic query = null;
            if (!string.IsNullOrWhiteSpace(originalContent))
                query = JsonConvert.DeserializeObject(originalContent);
            if (context.ActionDescriptor.EndpointMetadata.OfType<AllowAnonymousCustomeAttribute>().Any())
            {
                if (query != null)
                {
                    query.Token = context.HttpContext.User.GetToken();
                    var requestData = Encoding.UTF8.GetBytes(query.ToString());
                    stream = new MemoryStream(requestData);
                    request.Body = stream;

                }
                return;
            }

            if (context.ActionDescriptor.EndpointMetadata.OfType<AllowAnonymousAttribute>().Any())
            {
                if (query != null)
                {
                    var requestData = Encoding.UTF8.GetBytes(query.ToString());
                    stream = new MemoryStream(requestData);
                    request.Body = stream;

                }
                return;
            }

    
            if (context.HttpContext.User == null || string.IsNullOrWhiteSpace(context.HttpContext.User.GetToken()))
            {
                context.Result = new ObjectResult("امضای شما منقضی شده است") { StatusCode = 460 };
                return;
            }

            if (query != null)
            {
                query.Token = context.HttpContext.User.GetToken();
                byte[] requestData = Encoding.UTF8.GetBytes(query.ToString());
                stream = new MemoryStream(requestData);
                request.Body = stream;
            }

            if (context.ActionDescriptor.EndpointMetadata.OfType<CustomersAuth>().Any())
            {
                return;
            }
            if (context.ActionDescriptor.EndpointMetadata.OfType<CompanyAuth>().Any())
            {
                if (Convert.ToBoolean(context.HttpContext.User.GetAccessCompanyPanel()) == false)
                {
                    context.Result = new ObjectResult("شما دسترسی لازم را ندارید") { StatusCode = 462 };
                    return;
                }
                else
                {
                    return;
                }
            }
            if (Convert.ToBoolean(context.HttpContext.User.GetAccessPanel()) == false)
            {
                context.Result = new ObjectResult("شما دسترسی لازم را ندارید") { StatusCode = 462 };
                return;
            }
            var path = context.HttpContext.Request.Path;
            await _menusContext.Check_Access_Menus(new Check_Access_Menus.Inputs
            {
                ApiAddress = path,
                Token = context.HttpContext.User.GetToken()
            }, cancellationToken);
        }
    }


}
