﻿using Microsoft.AspNetCore.Mvc.Filters;
using Microsoft.AspNetCore.Mvc;
using Microsoft.Extensions.Configuration;
using System;

namespace Farakonesh.API.Filters
{
    public class CheckServiceKeyAttribute : Attribute, IAuthorizationFilter
    {
        private readonly string _configKey;

        public CheckServiceKeyAttribute(string configKey = "AccesskeyServiceWorker")
        {
            _configKey = configKey;
        }

        public void OnAuthorization(AuthorizationFilterContext context)
        {
            var config = context.HttpContext.RequestServices.GetService(typeof(IConfiguration)) as IConfiguration;
            var expectedKey = config.GetSection(_configKey).Value;

            if (!context.HttpContext.Request.Headers.TryGetValue("key-service", out var providedKey) ||
                string.IsNullOrWhiteSpace(providedKey) ||
                providedKey != expectedKey)
            {
                context.Result = new ContentResult
                {
                    StatusCode = 401,
                    Content = "کلید دسترسی نامعتبر است"
                };
            }
        }
    }
}
