param(
    [string]$PdbPath
)

try {
    if (Test-Path $PdbPath) {
        $resolved = Resolve-Path $PdbPath -ErrorAction SilentlyContinue
        if ($resolved) {
            $lockers = @(Get-Process dotnet -ErrorAction SilentlyContinue | Where-Object {
                try {
                    $_.Modules -ErrorAction Stop | Where-Object { $_.FileName -eq $resolved }
                } catch {
                    $false
                }
            })
            foreach ($p in $lockers) {
                try {
                    Write-Host "Killing dotnet process $($p.Id) locking PDB"
                    Stop-Process -Id $p.Id -Force -ErrorAction SilentlyContinue
                } catch {
                    Write-Warning "Failed to kill process $($p.Id)"
                }
            }
        }
    }
} catch {
    Write-Warning "Unexpected error: $_"
}

exit 0