﻿using Microsoft.AspNetCore.Http;
using System;
using System.Threading.Tasks;

namespace Farakonesh.API.Middlewares
{
    public class CorrelationIdMiddleware
    {
        private readonly RequestDelegate _next;
        private const string HeaderKey = "X-Correlation-ID";

        public CorrelationIdMiddleware(RequestDelegate next)
        {
            _next = next;
        }

        public async Task InvokeAsync(HttpContext context)
        {
            var correlationId = context.Request.Headers.ContainsKey(HeaderKey)
                ? context.Request.Headers[HeaderKey].ToString()
                : Guid.NewGuid().ToString("N");

            context.Response.Headers[HeaderKey] = correlationId;
            context.Items["CorrelationId"] = correlationId;

            NLog.MappedDiagnosticsLogicalContext.Set("CorrelationId", correlationId);

            try
            {
                await _next(context);
            }
            finally
            {
                NLog.MappedDiagnosticsLogicalContext.Remove("CorrelationId");
            }
        }
    }
}
