﻿using Farakonesh.Logic.CommonOperations;
using Farakonesh.Logic.Log;
using Microsoft.AspNetCore.Http;
using System;
using System.Net;
using System.Threading.Tasks;
using System.Diagnostics;
using Farakonesh.Models.API;
using static System.Runtime.InteropServices.JavaScript.JSType;

namespace Farakonesh.API.Middlewares
{
    public class ExceptionMiddleware
    {
        private readonly RequestDelegate _next;
        private readonly ILog _logger;
        /// <summary>
        /// Inject dependecies
        /// </summary>
        /// <param name="next"></param>
        /// <param name="logger"></param>
        public ExceptionMiddleware(RequestDelegate next, ILog logger)
        {
            _next = next;
            _logger = logger;
        }

        /// <summary>
        /// Manage pipeline
        /// </summary>
        /// <param name="httpContext"></param>
        /// <returns></returns>
        public async Task InvokeAsync(HttpContext httpContext)
        {
            try
            {
                await _next(httpContext);
            }
            catch (Exception ex)
            {
                await addLogExceptionAsync(httpContext, ex);
                await handleExceptionAsync(httpContext, ex);
            }
        }

        /// <summary>
        /// Manage exceptions
        /// </summary>
        /// <param name="context"></param>
        /// <param name="message"></param>
        /// <returns></returns>
        private async Task handleExceptionAsync(HttpContext context, Exception ex)
        {
            var message = ex.Message;
            context.Response.ContentType = "application/json";
            int statusCode = 501;
            if (message.Contains("::"))
            {
                statusCode = Convert.ToInt32(message.Split("::")[1]);
                message = message.Split("::")[0];
            }

            if(statusCode == 501 || statusCode == 560)
            {
                var requestUrl = $"{context.Request.Scheme}://{context.Request.Host}{context.Request.Path}{context.Request.QueryString}";
                var errorId = await _logger.LogErrorAndGetIdAsync(
    ex.Message,
    ex.InnerException?.Message ?? "",
    ex.StackTrace ?? "", requestUrl);
                message = $"خطا در سرور رخ داده است : شناسه پیگیری : {errorId}";
            }
            context.Response.StatusCode = statusCode;
            if (message.IsValidJson())
            {
                await context.Response.WriteAsync(message);
            }
            else
            {
                await context.Response.WriteAsync(new { message }.ObjToJson());
            }

        }

        private async Task addLogExceptionAsync(HttpContext context, Exception ex)
        {
            context.Response.ContentType = "application/json";
            int? statusCode = null;
            string message = ex.Message;
            if (ex.Message.Contains("::"))
            {
                statusCode = Convert.ToInt32(ex.Message.Split("::")[1]);
                message = ex.Message.Split("::")[0];
            }

            else
            {
                statusCode = 501;
            }

            context.Request.EnableBuffering();
            var url = string.Format("{0}://{1}{2}{3}", context.Request.Scheme, context.Request.Host, context.Request.Path, context.Request.QueryString);
            if (statusCode == 561 || statusCode == 562 || statusCode == 501 || statusCode == 560)
            {
                _logger.Error(ex.ObjToJson());
            }
            else
            {
                _logger.Warning(message);
            }
            await Task.CompletedTask;
        }



    }
}
