﻿using Microsoft.AspNetCore.Http.Extensions;
using Microsoft.AspNetCore.Http;
using Microsoft.Extensions.Primitives;
using System.Collections.Generic;
using System.Threading.Tasks;
using System.Linq;
using Farakonesh.API.Extensions;
using YamlDotNet.Core.Tokens;
using Farakonesh.Logic.ISecurity;
using Microsoft.AspNetCore.Authorization;

namespace Farakonesh.API.Middlewares
{
    public class ModifyQueryStringMiddleware
    {
        private readonly RequestDelegate _next;
        private readonly ITokenUserService _tokenUserService;
        public ModifyQueryStringMiddleware(RequestDelegate next, ITokenUserService tokenUserService)
        {
            _next = next;
            _tokenUserService = tokenUserService;

        }

        public async Task Invoke(HttpContext httpContext)
        {
            var endpoint = httpContext.GetEndpoint();

            if (endpoint != null)
            {
                var hasAllowAnonymous = endpoint.Metadata.OfType<AllowAnonymousAttribute>().Any();
                if (hasAllowAnonymous)
                {
                    await _next(httpContext);
                    return;
                }
            }
            if (httpContext.Request.Method == HttpMethods.Delete)
            {
                var queryitems = httpContext.Request.Query.SelectMany(x => x.Value, (col, value) => new KeyValuePair<string, string>(col.Key, value)).ToList();
                List<KeyValuePair<string, string>> queryparameters = new List<KeyValuePair<string, string>>();
                foreach (var item in queryitems)
                {

                    var value = item.Value;
                    if (item.Key == "Token" && string.IsNullOrWhiteSpace(item.Value))
                    {
                        value = _tokenUserService.getUserInfo().Token;
                    }
                    KeyValuePair<string, string> newqueryparameter = new KeyValuePair<string, string>(item.Key, value);
                    queryparameters.Add(newqueryparameter);
                }

                var contentType = httpContext.Request.ContentType;

                if (contentType != null && contentType.Contains("multipart/form-data"))
                {
                    var formitems = httpContext.Request.Form.SelectMany(x => x.Value, (col, value) => new KeyValuePair<string, string>(col.Key, value)).ToList();

                    Dictionary<string, StringValues> formparameters = new Dictionary<string, StringValues>();
                    foreach (var item in formitems)
                    {
                        var value = item.Value;
                        if (item.Key == "Token" && string.IsNullOrWhiteSpace(item.Value))
                        {
                            value = _tokenUserService.getUserInfo().Token;
                        }
                        formparameters.Add(item.Key, value);
                    }

                    if (!formparameters.Any(q => q.Key.Equals("Token") || q.Key.Equals("token")))
                    {
                        formparameters.Add("token", _tokenUserService.getUserInfo().Token);
                    }
                    var qb2 = new FormCollection(formparameters);

                    httpContext.Request.Form = qb2;
                }
                if (!queryparameters.Any(q => q.Key.Equals("Token") || q.Key.Equals("token")))
                {
                    KeyValuePair<string, string> newqueryparameterToken = new KeyValuePair<string, string>("Token", _tokenUserService.getUserInfo().Token);
                    queryparameters.Add(newqueryparameterToken);
                }
                var qb1 = new QueryBuilder(queryparameters);
                httpContext.Request.QueryString = qb1.ToQueryString();

            }
            await _next(httpContext);
        }
    }
}
