﻿using Microsoft.AspNetCore.Http;
using Farakonesh.Logic.Log;
using System.Diagnostics;
using System.Threading.Tasks;

namespace Farakonesh.API.Middlewares
{
    public class PerformanceMiddleware
    {
        private readonly RequestDelegate _next;
        private readonly ILog _logService;
        public PerformanceMiddleware(RequestDelegate next,ILog logService)
        {
            _next = next;
            _logService = logService;
        }

        public async Task Invoke(HttpContext context)
        {
            const int performanceTimeLog = 5000;

            var sw = new Stopwatch();

            sw.Start();

            await _next(context);

            sw.Stop();

            if (performanceTimeLog < sw.ElapsedMilliseconds)
                _logService.Information($"Request {context.Request?.Method} {context.Request?.Path.Value} it took about {sw.ElapsedMilliseconds} ms",4);
        }
    }
}
