﻿using Newtonsoft.Json;

namespace Farakonesh.Callback.Commons
{
    public class JSON
    {
        /// <summary>
        /// Convert json to object
        /// </summary>
        /// <typeparam name="T"></typeparam>
        /// <param name="json"></param>
        /// <returns></returns>
        public static T jsonToT<T>(string json)
        {
            if (string.IsNullOrWhiteSpace(json))
                throw new ArgumentNullException("Invalid json");
            var rst = JsonConvert.DeserializeObject<T>(json);
            return (rst);
        }

        /// <summary>
        /// Convert object to json
        /// </summary>
        /// <param name="data"></param>
        /// <returns></returns>
        public static string ObjToJson(object data)
        {
            if (data == null)
                throw new ArgumentNullException("Invalid data");

            var rst = JsonConvert.SerializeObject(data);
            return rst;
        }
    }
}
