﻿namespace Farakonesh.Callback.Commons
{
    public static class UrlHelper
    {
        public static string SanitizeUrl(this string url)
        {
            if(string.IsNullOrWhiteSpace(url))
            {
                return "";
            }
            if (Uri.TryCreate(url, UriKind.Absolute, out var uri) &&
                (uri.Scheme == Uri.UriSchemeHttp || uri.Scheme == Uri.UriSchemeHttps))
            {
                return url;
            }
            return "/";
        }
    }
}
