﻿using Microsoft.Extensions.Configuration;
using RestSharp;
using Farakonesh.Callback.Commons;
using Farakonesh.Callback.Model;
using System.Net;
using Farakonesh.Callback.Logs;

namespace Farakonesh.Callback.Logic
{
    public class Services: IServices
    {
        private readonly IConfiguration _configuration;
        private readonly ILog _log;
        public Services(IConfiguration configuration, ILog log)
        {
            _configuration = configuration;
            _log = log;
        }
        public string getBackUrl(string backUrl, Guid? orderId,Guid? companyId)
        {
            return string.IsNullOrWhiteSpace(backUrl) ? _configuration.GetValue<string>("backUrl") + "?orderId=" + orderId : companyId == null ? backUrl + "dashboard/orders/invoices?orderId=" + orderId : backUrl + "dashboard/orders/invoices/" + companyId;
        }
        public string getBackUrlWallet(string backUrl, Guid? companyId)
        {
            return string.IsNullOrWhiteSpace(backUrl) ? _configuration.GetValue<string>("backUrlWallet") : companyId == null ? backUrl + "dashboard/user/wallet": backUrl + "dashboard/user/wallet/" + companyId;
        }
        public async Task<ResponseVerifyModel<ResponseJibitVerifyModelItem>> verifyJibit(RequestVerifyModel model)
        {

            RestClient requestClient = new RestClient(getOptions());
            RestRequest request = new RestRequest("Transactions/Updatejb", Method.Put);
            request.AddHeader("Accept", "application/json");
            request.AddBody(model, "application/json");
            request.Timeout = TimeSpan.FromMilliseconds(300000);
            var response = await requestClient.ExecuteAsync<ResponseVerifyModel<ResponseJibitVerifyModelItem>>(request);
            _log.Information("Callback Verify Result: "+JSON.ObjToJson(response));
            if (response != null && response.IsSuccessful && response.StatusCode == HttpStatusCode.OK)
            {
                return response.Data;

            }
            else if (!string.IsNullOrWhiteSpace(response.Content) && response.Content.Contains("message"))
            {
                response.Data = new ResponseVerifyModel<ResponseJibitVerifyModelItem>() { message = JSON.jsonToT<ResponseErrorMessage>(response.Content).message };
                return response.Data;
            }
            return null;
        }
        /// <summary>
        /// وریفای تراکنش شارژ کیف پول - درگاه جیبیت
        /// </summary>
        /// <param name="model"></param>
        /// <param name="configuration"></param>
        /// <returns></returns>
        public async Task<ResponseVerifyModel<ResponseJibitVerifyModelItem>> verifyWalletJibit(RequestVerifyModel model)
        {
            RestClient requestClient = new RestClient(getOptions());

            RestRequest request = new RestRequest("Transactions/UpdateWalletjb", Method.Put);
            request.AddHeader("Accept", "application/json");
            request.AddBody(model, "application/json");
            request.Timeout = TimeSpan.FromMilliseconds(300000);
            var response = await requestClient.ExecuteAsync<ResponseVerifyModel<ResponseJibitVerifyModelItem>>(request);
            _log.Information("Callback Verify Result: " + JSON.ObjToJson(response));
            if (response != null && response.IsSuccessful && response.StatusCode == HttpStatusCode.OK)
            {
                return response.Data;

            }
            else if (!string.IsNullOrWhiteSpace(response.Content) && response.Content.Contains("message"))
            {
                response.Data = new ResponseVerifyModel<ResponseJibitVerifyModelItem>() { message = JSON.jsonToT<ResponseErrorMessage>(response.Content).message };
                return response.Data;
            }
            return null;
        }

        public async Task<ResponseVerifyModel<ResponseJibitVerifyModelItem>> verifyVandar(RequestVerifyModel model)
        {
            RestClient requestClient = new RestClient(getOptions());

            RestRequest request = new RestRequest("Transactions/Updatevn", Method.Put);
            request.AddHeader("Accept", "application/json");
            request.AddBody(model, "application/json");
            request.Timeout = TimeSpan.FromMilliseconds(300000);
            var response = await requestClient.ExecuteAsync<ResponseVerifyModel<ResponseJibitVerifyModelItem>>(request);
            _log.Information("Callback Verify Result: " + JSON.ObjToJson(response));
            if (response == null)
                return null;

            if (response.IsSuccessful && response.StatusCode == HttpStatusCode.OK)
            {
                return response.Data;
            }
            else if (!string.IsNullOrWhiteSpace(response.Content) && response.Content.Contains("message"))
            {
                response.Data = new ResponseVerifyModel<ResponseJibitVerifyModelItem>() { message = JSON.jsonToT<ResponseErrorMessage>(response.Content).message };
                return response.Data;
            }
            return null;
        }

        /// <summary>
        /// وریفای تراکنش شارژ کیف پول - درگاه وندار
        /// </summary>
        /// <param name="model"></param>
        /// <param name="configuration"></param>
        /// <returns></returns>
        public async Task<ResponseVerifyModel<ResponseJibitVerifyModelItem>> verifyWalletVandar(RequestVerifyModel model)
        {
            RestClient requestClient = new RestClient(getOptions());

            RestRequest request = new RestRequest("Transactions/UpdateWalletvn", Method.Put);
            request.AddHeader("Accept", "application/json");
            request.AddBody(model, "application/json");
            request.Timeout = TimeSpan.FromMilliseconds(300000);
            var response = await requestClient.ExecuteAsync<ResponseVerifyModel<ResponseJibitVerifyModelItem>>(request);
            _log.Information("Callback Verify Result: " + JSON.ObjToJson(response));
            if (response == null)
                return null;

            if (response.IsSuccessful && response.StatusCode == HttpStatusCode.OK)
            {
                return response.Data;
            }
            else if (!string.IsNullOrWhiteSpace(response.Content) && response.Content.Contains("message"))
            {
                response.Data = new ResponseVerifyModel<ResponseJibitVerifyModelItem>() { message = JSON.jsonToT<ResponseErrorMessage>(response.Content).message };
                return response.Data;
            }
            return null;
        }


        public async Task<ResponseVandarTransAction> getPayVandar(RequestVerifyModel model)
        {
            RestClient requestClient = new RestClient(getOptions());

            RestRequest request = new RestRequest("Transactions/Getvn", Method.Put);
            
            request.AddHeader("Accept", "application/json");
            request.AddBody(model, "application/json");
            request.Timeout = TimeSpan.FromMilliseconds(300000);
            var response = await requestClient.ExecuteAsync<ResponseVandarTransAction>(request);
            _log.Information("Callback Get Paid Vandar Result: " + JSON.ObjToJson(response));
            if (response != null && response.IsSuccessful && response.StatusCode == HttpStatusCode.OK)
            {
                return response.Data;
            }
            else if (!string.IsNullOrWhiteSpace(response.Content) && response.Content.Contains("message"))
            {
                response.Data = new ResponseVandarTransAction() { message = JSON.jsonToT<ResponseErrorMessage>(response.Content).message };
                return response.Data;
            }
            return null;
        }


        public async Task<ResponseVerifyModel<ResponseShepaTransAction>> verifyShepa(RequestVerifyModel model)
        {
            RestClient requestClient = new RestClient(getOptions());

            RestRequest request = new RestRequest("Transactions/Updatesh", Method.Put);
            request.AddHeader("Accept", "application/json");
            request.AddBody(model, "application/json");
            request.Timeout = TimeSpan.FromMilliseconds(300000);
            var response = await requestClient.ExecuteAsync<ResponseVerifyModel<ResponseShepaTransAction>>(request);
            _log.Information("Callback Verify Result: " + JSON.ObjToJson(response));
            if (response == null)
                return null;

            if (response.IsSuccessful && response.StatusCode == HttpStatusCode.OK)
            {
                return response.Data;
            }
            else if (!string.IsNullOrWhiteSpace(response.Content) && response.Content.Contains("message"))
            {
                response.Data = new ResponseVerifyModel<ResponseShepaTransAction>() { message = JSON.jsonToT<ResponseErrorMessage>(response.Content).message };
                return response.Data;
            }
            return null;
        }

        public async Task<ResponseVerifyModel<ResponseShepaTransAction>> verifyWalletShepa(RequestVerifyModel model)
        {
            RestClient requestClient = new RestClient(getOptions());

            RestRequest request = new RestRequest("Transactions/UpdateWalletsh", Method.Put);
            request.AddHeader("Accept", "application/json");
            request.AddBody(model, "application/json");
            request.Timeout = TimeSpan.FromMilliseconds(300000);
            var response = await requestClient.ExecuteAsync<ResponseVerifyModel<ResponseShepaTransAction>>(request);
            _log.Information("Callback Verify Result: " + JSON.ObjToJson(response));
            if (response == null)
                return null;

            if (response.IsSuccessful && response.StatusCode == HttpStatusCode.OK)
            {
                return response.Data;
            }
            else if (!string.IsNullOrWhiteSpace(response.Content) && response.Content.Contains("message"))
            {
                response.Data = new ResponseVerifyModel<ResponseShepaTransAction>() { message = JSON.jsonToT<ResponseErrorMessage>(response.Content).message };
                return response.Data;
            }
            return null;
        }

        public async Task<ResponseVerifyModel<ResponseJibitVerifyModelItem>> verifyZarinpal(RequestVerifyModel model)
        {
            RestClient requestClient = new RestClient(getOptions());

            RestRequest request = new RestRequest("Transactions/Updatezp", Method.Put);
            request.AddHeader("Accept", "application/json");
            request.AddBody(model, "application/json");
            request.Timeout = TimeSpan.FromMilliseconds(300000);
            var response = await requestClient.ExecuteAsync<ResponseVerifyModel<ResponseJibitVerifyModelItem>>(request);
            _log.Information("Callback Verify Result: " + JSON.ObjToJson(response));
            if (response == null)
                return null;

            if (response.IsSuccessful && response.StatusCode == HttpStatusCode.OK)
            {
                return response.Data;
            }
            else if (!string.IsNullOrWhiteSpace(response.Content) && response.Content.Contains("message"))
            {
                response.Data = new ResponseVerifyModel<ResponseJibitVerifyModelItem>() { message = JSON.jsonToT<ResponseErrorMessage>(response.Content).message };
                return response.Data;
            }
            return null;
        }

        public async Task<ResponseVerifyModel<ResponseJibitVerifyModelItem>> verifyWalletZarinpal(RequestVerifyModel model)
        {
            RestClient requestClient = new RestClient(getOptions());

            RestRequest request = new RestRequest("Transactions/UpdateWalletzp", Method.Put);
            request.AddHeader("Accept", "application/json");
            request.AddBody(model, "application/json");
            request.Timeout = TimeSpan.FromMilliseconds(300000);
            var response = await requestClient.ExecuteAsync<ResponseVerifyModel<ResponseJibitVerifyModelItem>>(request);
            _log.Information("Callback Verify Result: " + JSON.ObjToJson(response));
            if (response == null)
                return null;

            if (response.IsSuccessful && response.StatusCode == HttpStatusCode.OK)
            {
                return response.Data;
            }
            else if (!string.IsNullOrWhiteSpace(response.Content) && response.Content.Contains("message"))
            {
                response.Data = new ResponseVerifyModel<ResponseJibitVerifyModelItem>() { message = JSON.jsonToT<ResponseErrorMessage>(response.Content).message };
                return response.Data;
            }
            return null;
        }

        public async Task<bool> CollectAnalytics(RequestCollectAnalytics model)
        {
            RestClient requestClient = new RestClient(getOptions());
            RestRequest request = new RestRequest("ClientTrackingDataExternal/Collect", Method.Post);
            request.AddHeader("Accept", "application/json");
            request.AddHeader("key-service", _configuration.GetValue<string>("Accesskey"));
            request.AddBody(model, "application/json");
            request.Timeout = TimeSpan.FromMilliseconds(300000);
            var response = await requestClient.ExecuteAsync<object>(request);
            _log.Information("Callback Collect Analytics Result: " + JSON.ObjToJson(response));
            if (response != null && response.IsSuccessful && response.StatusCode == HttpStatusCode.OK)
            {
                return true;

            }
            return false;
        }

        public async Task<ResponseVerifyModel<ResponseCollectAnalytics>> GetAnalyticsData(RequestGetAnalytics model)
        {
            RestClient requestClient = new RestClient(getOptions());
            RestRequest request = new RestRequest("ClientTrackingDataExternal/Get", Method.Put);
            request.AddHeader("Accept", "application/json");
            request.AddHeader("key-service", _configuration.GetValue<string>("Accesskey"));
            request.AddBody(model, "application/json");
            request.Timeout = TimeSpan.FromMilliseconds(300000);
            var response = await requestClient.ExecuteAsync<ResponseVerifyModel<ResponseCollectAnalytics>>(request);
            if (response != null && response.IsSuccessful && response.StatusCode == HttpStatusCode.OK)
            {
                return response.Data;

            }
            return null;
        }

        private RestClientOptions getOptions()
        {
            var options = new RestClientOptions(_configuration.GetValue<string>("apiRoot"))
            {
                ThrowOnAnyError = false,
                MaxTimeout = 300000
            };
            return options;
        }
    }
}
