﻿using NLog;
using NLog.Web;
namespace Farakonesh.Callback.Logs
{
    public class Log: ILog
    {
        private static readonly Logger logger = NLogBuilder.ConfigureNLog("nlog.config").GetCurrentClassLogger();
        public void Information(string message, int logType)
        {
            logger.WithProperty("logType", logType).Info(message);
        }

        public void Information(string message)
        {
            logger.Info(message);
        }

        public void Warning(string message)
        {
            logger.WithProperty("logType", 4).Warn(message);
        }

        public void Debug(string message)
        {
            logger.Debug(message);
        }

        public void Error(string message)
        {
            logger.WithProperty("logType", 5).Error(message);
        }

        public void Add(Exception e, string customMessage = null)
        {
            string text = string.Format("{0}\nException: {1}\nStackTrace: {2}\n",
                customMessage ?? "", e.Message, e.StackTrace);
            this.Add(text);
        }

        public void Add(string message)
        {
            Information(message);
        }
    }
}
