﻿using Ganss.Xss;

namespace Farakonesh.Callback.Middlewares
{
    public class HtmlSanitizerMiddleware
    {
        private readonly RequestDelegate _next;
        private readonly HtmlSanitizer _sanitizer;
        private readonly HashSet<string> _urlParameters;

        public HtmlSanitizerMiddleware(RequestDelegate next)
        {
            _next = next;
            _sanitizer = new HtmlSanitizer();

            _urlParameters = new HashSet<string>{
            "backUrl",
            "redirectUrl",
            "returnUrl",
            "url",
            "callbackUrl" };


            _sanitizer.AllowedTags.Clear();
        }

        public async Task InvokeAsync(HttpContext context)
        {
            var query = context.Request.Query;
            var newQuery = new Dictionary<string, Microsoft.Extensions.Primitives.StringValues>();

            foreach (var param in query)
            {
                if (_urlParameters.Contains(param.Key))
                {
                    newQuery[param.Key] = param.Value;
                }
                else
                {
                    var cleanValue = _sanitizer.Sanitize(param.Value);
                    newQuery[param.Key] = cleanValue;
                }
            }

            context.Request.QueryString = QueryString.Create(newQuery);
            if (context.Request.HasFormContentType)
            {
                var form = await context.Request.ReadFormAsync();
                var newForm = new Dictionary<string, Microsoft.Extensions.Primitives.StringValues>();

                foreach (var field in form)
                {
                    if (_urlParameters.Contains(field.Key))
                    {
                        newForm[field.Key] = field.Value;
                    }
                    else
                    {
                        var cleanValue = _sanitizer.Sanitize(field.Value);
                        newForm[field.Key] = cleanValue;
                    }
                }

                context.Request.Form = new FormCollection(newForm);
            }

            await _next(context);
        }
    }
}
