﻿using Farakonesh.Callback.Commons;
using Farakonesh.Callback.Helpers;
using Farakonesh.Callback.Logic;
using Farakonesh.Callback.Logs;
using Farakonesh.Callback.Model;
using Farakonesh.Shared.Helpers;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.Mvc.RazorPages;

namespace Farakonesh.Callback.Pages
{
    [IgnoreAntiforgeryToken(Order = 1001)]
    public class CallbackWalletModel : PageModel
    {
        [BindProperty]
        public string ReturnUrl { get; set; }
        public string Status { get; set; }
        public string Message { get; set; }
        [BindProperty]
        public string PspReferenceNumber { get; set; }
        [BindProperty]
        public string Amount { get; set; }
        [BindProperty]
        public string AmountSeparateNumber { get; set; }
        [BindProperty]
        public string PurchaseId { get; set; }
        [BindProperty]
        public string ClientReferenceNumber { get; set; }
        [BindProperty]
        public Guid? WalletId { get; set; }
        [BindProperty]
        public string BackUrl { get; set; }
        private readonly IConfiguration _configuration;
        private readonly IServices _services;
        private readonly ILog _log;
        public CallbackWalletModel(IConfiguration configuration, IServices services,
            ILog log)
        {
            _log = log;
            _configuration = configuration;
            _services = services;
        }
        public async Task OnGetAsync()
        {
            this.BackUrl = _configuration.GetValue<string>("backUrlWallet");
            if (Request.Query != null && Request.Query.Count > 0 && Request.Query.ContainsKey("returnUrl"))
            {
                this.ReturnUrl = Request.Query["returnUrl"].ToString().SanitizeUrl();
            }

            if (Request.Query != null && Request.Query.Count > 0 && Request.Query.ContainsKey("payment_status"))
            {
                switch (Request.Query["payment_status"].ToString())
                {
                    case "OK":
                        Message = "پرداخت شما با موفقیت انجام شد.";
                        Status = "alert-success";
                        PurchaseId = Request.Query["token"].ToString();

                        break;
                    default:
                        Message = "پرداخت شما با شکست مواجه شد ، در صورت کسر وجه ، مبلغ طی 72 ساعت به حساب شما برگشت داده خواهد شد.";
                        Status = "alert-danger";
                        break;
                }

                var responseTransaction = await _services.getPayVandar(new Model.RequestVerifyModel
                {
                    purchaseId = PurchaseId

                });
                if (responseTransaction == null || responseTransaction.data == null)
                {
                    Message = "پرداخت شما با شکست مواجه شد ، در صورت کسر وجه ، مبلغ طی 72 ساعت به حساب شما برگشت داده خواهد شد.";
                    Status = "alert-danger";
                }
                else
                {

                    var response = await _services.verifyWalletVandar(new Model.RequestVerifyModel
                    {
                        paidAmount = responseTransaction.data.amount,
                        purchaseId = PurchaseId
,
                        status = Request.Query["payment_status"].ToString(),
                        transactionCode = responseTransaction.data.refnumber,
                        trackingCode = responseTransaction.data.trackingCode
                    });
                    PspReferenceNumber = responseTransaction.data.refnumber;
                    PurchaseId = responseTransaction.data.trackingCode;
                    Amount = responseTransaction.data.amount;
                    AmountSeparateNumber = response.data.finalAmount.moneyFormat();
                    if (response != null && response.data != null && string.IsNullOrWhiteSpace(response.message))
                    {
                        this.BackUrl = _services.getBackUrlWallet(response.data.backUrl, response.data.companyId).SanitizeUrl();
                        Status = "alert-success";
                    }
                    else if (response != null && !string.IsNullOrWhiteSpace(response.message))
                    {
                        Message = response.message;
                        Status = "alert-danger";
                    }
                    else
                    {
                        Message = "پرداخت شما با شکست مواجه شد ، در صورت کسر وجه ، مبلغ طی 72 ساعت به حساب شما برگشت داده خواهد شد.";
                        Status = "alert-danger";
                    }
                }
            }
            else if (Request.Query != null && Request.Query.Count > 0 && Request.Query.ContainsKey("Status") && Request.Query.ContainsKey("Authority"))
            {
                switch (Request.Query["Status"].ToString())
                {
                    case "OK":
                        Message = "پرداخت شما با موفقیت انجام شد.";
                        Status = "alert-success";
                        PurchaseId = Request.Query["Authority"].ToString();

                        break;
                    default:
                        Message = "پرداخت شما با شکست مواجه شد ، در صورت کسر وجه ، مبلغ طی 72 ساعت به حساب شما برگشت داده خواهد شد.";
                        Status = "alert-danger";
                        break;
                }

                var response = await _services.verifyWalletZarinpal(new Model.RequestVerifyModel
                {
                    paidAmount = null,
                    purchaseId = PurchaseId
,
                    status = Request.Query["Status"].ToString(),
                    transactionCode = null,
                    trackingCode = null
                });

                if (response != null && response.data != null && string.IsNullOrWhiteSpace(response.message)
                    && !string.IsNullOrWhiteSpace(response.data.trackingCode))
                {
                    this.BackUrl = _services.getBackUrlWallet(response.data.backUrl, response.data.companyId).SanitizeUrl();
                    Status = "alert-success";
                    PspReferenceNumber = response.data.trackingCode;
                    Amount = response.data.finalAmount;
                    AmountSeparateNumber = response.data.finalAmount.moneyFormat();
                }
                else if (response != null && !string.IsNullOrWhiteSpace(response.message))
                {
                    Message = response.message;
                    Status = "alert-danger";
                }
                else
                {
                    Message = "پرداخت شما با شکست مواجه شد ، در صورت کسر وجه ، مبلغ طی 72 ساعت به حساب شما برگشت داده خواهد شد.";
                    Status = "alert-danger";
                }

            }
            else if (Request.Query != null && Request.Query.Count > 0 && Request.Query.ContainsKey("status"))
            {
                switch (Request.Query["status"].ToString())
                {
                    case "success":
                        Message = "پرداخت شما با موفقیت انجام شد.";
                        Status = "alert-success";

                        break;
                    default:
                        Message = "پرداخت شما با شکست مواجه شد ، در صورت کسر وجه ، مبلغ طی 72 ساعت به حساب شما برگشت داده خواهد شد.";
                        Status = "alert-danger";
                        break;
                }
                if (Request.Query.ContainsKey("token") && Request.Query["token"].ToString() != "")
                {
                    PurchaseId = Request.Query["token"].ToString();
                }

                var response = await _services.verifyWalletShepa(new Model.RequestVerifyModel
                {
                    paidAmount = null,
                    purchaseId = PurchaseId
,
                    status = Request.Query["status"].ToString(),
                    transactionCode = null,
                    trackingCode = null
                });

                if (response != null && response.data != null && response.data.result != null && string.IsNullOrWhiteSpace(response.message))
                {
                    this.BackUrl = _services.getBackUrlWallet(response.data.backUrl, response.data.companyId).SanitizeUrl();
                    Status = "alert-success";
                    PspReferenceNumber = response.data.result.transaction_id.ToString();
                    PurchaseId = response.data.result.refid.ToString();
                    Amount = response.data.result.amount.ToString();
                    AmountSeparateNumber = response.data.finalAmount.moneyFormat();
                }
                else if (response != null && !string.IsNullOrWhiteSpace(response.message))
                {
                    Message = response.message;
                    Status = "alert-danger";
                }
                else
                {
                    Message = "پرداخت شما با شکست مواجه شد ، در صورت کسر وجه ، مبلغ طی 72 ساعت به حساب شما برگشت داده خواهد شد.";
                    Status = "alert-danger";
                }

            }
            else
            {
                Status = "alert-danger";
                Message = "خطا در دریافت نتیجه پرداخت رخ داده است!";
            }
        }



        public async Task<IActionResult> OnPostAsync()
        {
            this.BackUrl = _configuration.GetValue<string>("backUrlWallet");
            if (Request != null && Request.Form != null && Request.Form.Count > 0)
            {
                _log.Information("Request Form Verify Callback: "+JSON.ObjToJson(Request.Form));
                switch (Request.Form["status"].ToString())
                {
                    case "EXPIRED":
                        Message = "درخواست پرداخت شما منقضی شده است";
                        Status = "alert-danger";
                        break;
                    case "FAILED":
                        Message = "پرداخت شما با شکست مواجه شد ، در صورت کسر وجه ، مبلغ طی 72 ساعت به حساب شما برگشت داده خواهد شد.";
                        Status = "alert-danger";
                        break;
                    case "IN_PROGRESS":
                        Message = "پرداخت در حال انجام می باشد.";
                        Status = "alert-success";
                        break;
                    case "SUCCESSFUL":
                        Message = "پرداخت شما با موفقیت انجام شد.";
                        Status = "alert-success";
                        PspReferenceNumber = Request.Form["pspReferenceNumber"];
                        Amount = Request.Form["amount"];
                        PurchaseId = Request.Form["purchaseId"];
                        ClientReferenceNumber = Request.Form["clientReferenceNumber"];

                        break;
                    default:
                        Message = "پرداخت شما با شکست مواجه شد ، در صورت کسر وجه ، مبلغ طی 72 ساعت به حساب شما برگشت داده خواهد شد.";
                        Status = "alert-danger";
                        break;
                }
                var response = await _services.verifyWalletJibit(new Model.RequestVerifyModel
                {
                    paidAmount = Amount,
                    purchaseId = PurchaseId
                ,
                    status = Request.Form["status"],
                    transactionCode = PspReferenceNumber,
                    trackingCode = ClientReferenceNumber
                });
                if (response != null && response.data != null && string.IsNullOrWhiteSpace(response.message))
                {
                    this.WalletId = response?.data?.walletId;
                    this.BackUrl = _services.getBackUrlWallet(response.data.backUrl, response.data.companyId);
                    if (NumberHelper.TryGetPositiveDecimal(this.Amount, out decimal amount))
                    {
                        amount = (amount / 10);
                        AmountSeparateNumber = amount.moneyFormat();
                    }
                    if (response.data.status == "SUCCESSFUL" || response.data.status == "IN_PROGRESS")
                    {
                        Status = "alert-success";
                    }
                    else
                    {
                        Status = "alert-danger";
                    }

                }
                else if (response != null && !string.IsNullOrWhiteSpace(response.message))
                {
                    Message = response.message;
                    Status = "alert-danger";
                }
                else
                {
                    Message = "پرداخت شما با شکست مواجه شد ، در صورت کسر وجه ، مبلغ طی 72 ساعت به حساب شما برگشت داده خواهد شد.";
                    Status = "alert-danger";
                }

            }
            else
            {
                Status = "alert-danger";
                Message = "خطا در دریافت نتیجه پرداخت رخ داده است!";
            }
            _ = Task.Run(async () =>
            {
                try
                {
                    var responseAnalyticsData = new ResponseVerifyModel<ResponseCollectAnalytics>();
                    if (this.WalletId != null)
                    {
                        responseAnalyticsData = await _services.GetAnalyticsData(new RequestGetAnalytics
                        {
                            orderId = this.WalletId.ToString()
                        });
                    }
                    if (responseAnalyticsData != null && responseAnalyticsData.data != null
                    && !string.IsNullOrWhiteSpace(responseAnalyticsData.data.gA4ClientId))
                    {
                        var events = new List<RequestCollectAnalyticsEvent>();
                        events.Add(new RequestCollectAnalyticsEvent
                        {
                            Name = "callbackJibitWallet",
                            Params = new
                            {
                                status = this.Status,
                                walletId = this.WalletId.ToString(),
                                value = this.AmountSeparateNumber,
                            }
                        });

                        await _services.CollectAnalytics(new RequestCollectAnalytics
                        {
                            ClientId = responseAnalyticsData.data.gA4ClientId,
                            Events = events
                        });
                    }
                }
                catch (Exception ex)
                {
                    _log.Error("Background task failed:" + JSON.ObjToJson(ex));
                }
            });

            return Page();
        }
    }
}
