﻿document.addEventListener('DOMContentLoaded', function () {
    initializeCallbackTimer();
});

function initializeCallbackTimer() {
    try {
        const backButton = document.getElementById('back-button');
        const countdownElement = document.getElementById('countdown');

        if (!backButton) {
            return;
        }

        if (!countdownElement) {
            return;
        }

        const backUrl = backButton.getAttribute('href');

        if (!backUrl) {
            countdownElement.textContent = 'خطا در انتقال';
            return;
        }

        let countdown = 5;
        let timerInterval;

        function updateTimer() {
            countdownElement.textContent = countdown;

            if (countdown <= 0) {
                clearInterval(timerInterval);
                redirectToPanel();
                return;
            }
            countdown--;
        }

        function redirectToPanel() {
            var amountElement = document.getElementById("amount");
            if (amountElement != undefined && amountElement != null && amountElement != '') {
                window.location.href = backUrl;
            }

        }

        timerInterval = setInterval(updateTimer, 1000);

        savePaymentInfo();

        backButton.addEventListener('click', handleManualRedirect);

    } catch (error) {
        console.error('خطا در اجرای تایمر:', error);
    }
}

function savePaymentInfo() {
    try {
        const paymentInfo = {
            time: new Date().toISOString(),
            status: 'success'
        };
        sessionStorage.setItem('lastPayment', JSON.stringify(paymentInfo));
    } catch (error) {
        console.warn('ذخیره اطلاعات پرداخت با خطا مواجه شد:', error);
    }
}

function handleManualRedirect(e) {
    e.preventDefault();
    const backButton = document.getElementById('back-button');
    const backUrl = backButton.getAttribute('href');

    const highestTimeoutId = setTimeout(() => { });
    for (let i = 0; i < highestTimeoutId; i++) {
        clearTimeout(i);
    }

    window.location.href = backUrl;
}