﻿using Dapper;
using Microsoft.AspNetCore.Http;
using Farakonesh.Models.Database;
using System;
using System.Collections.Generic;
using System.Text;

namespace Farakonesh.DP.DapperORM
{
    public class Common
    {
        public DynamicParameters getEmptyParams()
        {
            var p = new DynamicParameters();
            IHttpContextAccessor ctx = new HttpContextAccessor();
            if (ctx.HttpContext != null)
            {
                p.Add("@ip", ctx.HttpContext.Request.HttpContext.Connection.RemoteIpAddress.ToString());
            }
            else
            {
                p.Add("@ip", "1.1.1.1");
            }

            return p;
        }

 
        public DynamicParameters getSearchParams()
        {

            var p = getEmptyParams();
            int actualSize = 0;
            p.Add("@actualSize", actualSize, System.Data.DbType.Int32, System.Data.ParameterDirection.Output);

            return p;
        }

        public static DBResult<TOutput> GetResult<TOutput>(DynamicParameters outputParams, TOutput data)
        {
            if (outputParams == null)
                throw new ArgumentNullException("Invalid outputParams");

            var rst = new DBResult<TOutput>()
            {
                Data = data
            };

            try
            {
                rst.ActualSize = outputParams.Get<int>("actualSize");
            }
            catch (Exception e)
            {
                rst.ActualSize = data == null ? 0 : 1;
            }

            return rst;
        }
        public static DBResult<IEnumerable<TOutput>> GetResult<TOutput>(DynamicParameters outputParams, IEnumerable<TOutput> data)
        {
            if (outputParams == null)
                throw new ArgumentNullException("Invalid outputParams");

            var rst = new DBResult<IEnumerable<TOutput>>()
            {
                Data = data
            };

            try
            {
                rst.ActualSize = outputParams.Get<int>("actualSize");
            }
            catch (Exception e)
            {
                rst.ActualSize = data == null ? 0 : 1;
            }

            return rst;
        }

        public static DBResult GetResult(DynamicParameters outputParams, object data)
        {
            if (outputParams == null)
                throw new ArgumentNullException("Invalid outputParams");

            var rst = new DBResult()
            {
                Data = data
            };
            try
            {
                rst.ActualSize = outputParams.Get<int>("actualSize");
            }
            catch (Exception e)
            {
                rst.ActualSize = data == null ? 0 : 1;
            }

            return rst;
        }


    }
}
