﻿using Dapper;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.setting;
using System;
using System.Collections.Generic;
using System.Data;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.DP.DapperORM
{
    public interface ISqlExecuter
    {
        Task<T> SingleOrDefaultAsync<T>(CancellationToken cancellationToken, string sql, object param = null, System.Data.CommandType? commandType = null);
        /// <summary>
        /// Execute database query
        /// </summary>
        /// <typeparam name="T"></typeparam>
        /// <param name="sql"></param>
        /// <param name="param"></param>
        /// <param name="commandType"></param>
        /// <returns></returns>
        IEnumerable<T> Query<T>(CancellationToken cancellationToken,string sql, object param = null, CommandType? commandType = null);
        Task<IEnumerable<T>> QueryAsync<T>(CancellationToken cancellationToken,string sql, object param = null, CommandType? commandType = null);
        Task<T> FirstOrDefaultAsync<T>(CancellationToken cancellationToken,string sql, object param = null, System.Data.CommandType? commandType = null);
        Task<SqlMapper.GridReader> QueryMultipleAsync(
     CancellationToken cancellationToken,
     string sql,
     object param = null,
     CommandType? commandType = null);
        Task<bool> ExecuteAsync(CancellationToken cancellationToken,string sql, object param = null, System.Data.CommandType? commandType = null);
    }
}
