﻿using Dapper;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.setting;
using Farakonesh.Shared.Exceptions;
using Microsoft.Data.SqlClient;
using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using System.Security.Cryptography;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.DP.DapperORM
{
    public class SqlExecuter : ISqlExecuter
    {
        private readonly string _connectionString;


        public SqlExecuter(string connectionString)
        {
            _connectionString = connectionString;
        }


        /// <summary>
        /// Execute database query
        /// </summary>
        /// <typeparam name="T"></typeparam>
        /// <param name="sql"></param>
        /// <param name="param"></param>
        /// <param name="commandType"></param>
        /// <returns></returns>
        public IEnumerable<T> Query<T>(CancellationToken cancellationToken, string sql, object param = null, System.Data.CommandType? commandType = null)
        {
            var rst = QueryAsync<T>(cancellationToken, sql, param, commandType);
            return rst.Result;
        }


        /// <summary>
        /// Execute database query asyncronous
        /// </summary>
        /// <typeparam name="T"></typeparam>
        /// <param name="sql"></param>
        /// <param name="param"></param>
        /// <param name="commandType"></param>
        /// <returns></returns>
        public async Task<IEnumerable<T>> QueryAsync<T>(CancellationToken cancellationToken, string sql, object param = null, System.Data.CommandType? commandType = null)
        {
            try
            {
                IEnumerable<T> rst = null;
                using (var connection = new SqlConnection(_connectionString))
                {
                    var command = new CommandDefinition(sql, param, commandType: commandType, cancellationToken: cancellationToken);
                    rst = await connection.QueryAsync<T>(command);
                }

                return rst;
            }
            catch (Exception ex)
            {
                throw new QueryException(ex.Message);
            }
        }

        public async Task<T> FirstOrDefaultAsync<T>(CancellationToken cancellationToken, string sql, object param = null, System.Data.CommandType? commandType = null)
        {
            try
            {
                T rst = default(T);
                using (var connection = new SqlConnection(_connectionString))
                {
                    var command = new CommandDefinition(sql, param, commandType: commandType, cancellationToken: cancellationToken);
                    rst = await connection.QueryFirstOrDefaultAsync<T>(command);
                }

                return rst;
            }
            catch (Exception ex)
            {
                throw new QueryException(ex.Message);
            }
        }

        public async Task<T> SingleOrDefaultAsync<T>(CancellationToken cancellationToken, string sql, object param = null, System.Data.CommandType? commandType = null)
        {
            try
            {
                T rst = default(T);
                using (var connection = new SqlConnection(_connectionString))
                {
                    var command = new CommandDefinition(sql, param, commandType: commandType, cancellationToken: cancellationToken);
                    rst = await connection.QuerySingleOrDefaultAsync<T>(command);
                }

                return rst;
            }
            catch (Exception ex)
            {
                throw new QueryException(ex.Message);
            }
        }


        public async Task<SqlMapper.GridReader> QueryMultipleAsync(
     CancellationToken cancellationToken,
     string sql,
     object param = null,
     CommandType? commandType = null)
        {
            try
            {
                var connection = new SqlConnection(_connectionString);
                var command = new CommandDefinition(sql, param, commandType: commandType, cancellationToken: cancellationToken);
                return await connection.QueryMultipleAsync(command);
            }
            catch (Exception ex)
            {
                throw new QueryException(ex.Message);
            }
        }


        public async Task<bool> ExecuteAsync(CancellationToken cancellationToken, string sql, object param = null, System.Data.CommandType? commandType = null)
        {
            try
            {
                using (var connection = new SqlConnection(_connectionString))
                {
                    var command = new CommandDefinition(sql, param, commandType: commandType, cancellationToken: cancellationToken);
                    await connection.ExecuteAsync(command);
                }
                return true;
            }
            catch (Exception ex)
            {
                throw new QueryException(ex.Message);
            }

        }
    }
}
