﻿using Microsoft.Extensions.DependencyInjection;
using Farakonesh.Logic.Database;
using Farakonesh.Logic.Database.BlockChain;
using Farakonesh.Logic.Database.Crm;
using Farakonesh.Logic.Database.dbo;
using Farakonesh.Logic.Database.Order;
using Farakonesh.Logic.Database.User;
using Farakonesh.Logic.DatabaseLog;
using Farakonesh.Logic.IDatabase.IBlockChain;
using Farakonesh.Logic.IDatabase.ICrm;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Logic.IDatabase.IQueue;
using Farakonesh.Logic.IDatabase.IReport;
using Farakonesh.Logic.IDatabase.IUser;
using Farakonesh.Logic.IDatabaseLog;
using Farakonesh.Logic.Database.Queue;

namespace Farakonesh.IOC
{
    public class ContextIOC
    {
        public static void Configure(IServiceCollection services)
        {
            services.AddScoped<IUserContext, UserContext>();
            services.AddScoped<IDiscountContext, DiscountContext>();
            services.AddScoped<IPublicContext, PublicContext>();
            services.AddScoped<IOrderContext, OrderContext>();
            services.AddScoped<IReportContext, ReportContext>();
            services.AddScoped<IQueueContext, QueueContext>();
            services.AddScoped<ISettingContext, SettingContext>();
            services.AddScoped<IQuestionsContext, QuestionsContext>();
            services.AddScoped<IMenusContext, MenusContext>();
            services.AddScoped<IBankAccountContext, BankAccountContext>();
            services.AddScoped<ICompanyContext, CompanyContext>();
            services.AddScoped<ITagContext, TagContext>();
            services.AddScoped<ILevelContext, LevelContext>();
            services.AddScoped<IWalletContext, WalletContext>();
            services.AddScoped<ITransActionContext, TransActionContext>();
            services.AddScoped<IApplicationFeeContext, ApplicationFeeContext>();
            services.AddScoped<IRamRegionServerContext, RamRegionServerContext>();
            services.AddScoped<ICurrencyContext, CurrencyContext>();
            services.AddScoped<IAuthenticationContext, AuthenticationContext>();
            services.AddScoped<IGiftCardContext, GiftCardContext>();
            services.AddScoped<IPayeerContext, PayeerContext>();
            services.AddScoped<IPremiumAccountContext, PremiumAccountContext>();
            services.AddScoped<IStaticContext, StaticContext>();
            services.AddScoped<IPaypalContext, PaypalContext>();
            services.AddScoped<INoteContext, NoteContext>();
            services.AddScoped<ICountryContext, CountryContext>();
            services.AddScoped<IAdvertisingContext, AdvertisingContext>();
            services.AddScoped<IPerfectMoneyContext, PerfectMoneyContext>();
            services.AddScoped<IWiseContext, WiseContext>();
            services.AddScoped<IAccountNumberContext, AccountNumberContext>();
            services.AddScoped<ISendRemittanceToIranCotext, SendRemittanceToIranCotext>();
            services.AddScoped<IVirtualServerContext, VirtualServerContext>();
            services.AddScoped<IPaymentInternationalSitesContext, PaymentInternationalSitesContext>();
            services.AddScoped<ISubjectContext, SubjectContext>();
            services.AddScoped<IPartContext, PartContext>();
            services.AddScoped<IAccountInformationContext, AccountInformationContext>();
            services.AddScoped<IBlackListContext, BlackListContext>();
            services.AddScoped<IFreeOrderContext, FreeOrderContext>();
            services.AddScoped<ITicketContext, TicketContext>();
            services.AddScoped<ICurrencyWageContext, CurrencyWageContext>();
            services.AddScoped<IIncomeCashExchangeContext, IncomeCashExchangeContext>();
            services.AddScoped<IInboxContext, InboxContext>();
            services.AddScoped<ICurrencyWarehouseContext, CurrencyWarehouseContext>();
            services.AddScoped<ICurrencyHistoryWarehouseContext, CurrencyHistoryWarehouseContext>();
            services.AddScoped<ISwiftTransfreContext, SwiftTransfreContext>();
            services.AddScoped<ILogContext, LogContext>();
            services.AddScoped<IAccountServiceContext, AccountServiceContext>();
            services.AddScoped<IScenarioContext, ScenarioContext>();
            services.AddScoped<ICurrencyHistoryWarehouseTomanContext, CurrencyHistoryWarehouseTomanContext>();
            services.AddScoped<ICurrencyWarehouseTomanContext, CurrencyWarehouseTomanContext>();
            services.AddScoped<ICallHistoryContext, CallHistoryContext>();
            services.AddScoped<IGiftContext, GiftContext>();
            services.AddScoped<IHistoryDepositBlockChainContext, HistoryDepositBlockChainContext>();
            services.AddScoped<IWalletBlockChainContext, WalletBlockChainContext>();
            services.AddScoped<INetworkBlockChainContext, NetworkBlockChainContext>();
            services.AddScoped<ICurrencyBlockChainContext, CurrencyBlockChainContext>();
            services.AddScoped<IPaymentLinkContext, PaymentLinkContext>();
            services.AddScoped<IShiftContext, ShiftContext>();
            services.AddScoped<ISupportPhonesContext, SupportPhonesContext>();
            services.AddScoped<IVersionContext, VersionContext>();
            services.AddScoped<ISettingJobsContext, SettingJobsContext>();
            services.AddScoped<IInternalNumbersContext, InternalNumbersContext>();
            services.AddScoped<IServiceKeysContext, ServiceKeysContext>();
            services.AddScoped<IRFMCategoryDefinitionsContext, RFMCategoryDefinitionsContext>();
            services.AddScoped<IWeightFeeContext, WeightFeeContext>();
            services.AddScoped<IRFMScoreRangeContext, RFMScoreRangeContext>();
            services.AddScoped<IAddressContext, AddressContext>();
        }
    }
}
