﻿using Microsoft.Extensions.DependencyInjection;
using Farakonesh.Logic.CommonOperations;
using Farakonesh.Logic.Database.dbo;
using Farakonesh.Logic.ICommonOperations;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.IQueue;
using Farakonesh.Logic.ISecurity;
using Farakonesh.Logic.IServices.IApp;
using Farakonesh.Logic.IServices.IApp.ICompany;
using Farakonesh.Logic.IServices.IApp.ICryptoCurrency;
using Farakonesh.Logic.IServices.IApp.Idbo;
using Farakonesh.Logic.IServices.IApp.IOrder;
using Farakonesh.Logic.IServices.IApp.ISms;
using Farakonesh.Logic.IServices.IApp.ISystems;
using Farakonesh.Logic.IServices.IApp.IUser;
using Farakonesh.Logic.IServices.ICache;
using Farakonesh.Logic.IServices.IRestRequest;
using Farakonesh.Logic.Security;
using Farakonesh.Logic.Services.App;
using Farakonesh.Logic.Services.App.Company;
using Farakonesh.Logic.Services.App.CryptoCurrency;
using Farakonesh.Logic.Services.App.dbo;
using Farakonesh.Logic.Services.App.Order;
using Farakonesh.Logic.Services.App.Order.PremiumAccount;
using Farakonesh.Logic.Services.App.Payeer;
using Farakonesh.Logic.Services.App.PPG;
using Farakonesh.Logic.Services.App.Sms;
using Farakonesh.Logic.Services.App.Systems;
using Farakonesh.Logic.Services.App.User;
using Farakonesh.Logic.Services.Cache;
using Farakonesh.Logic.Services.Queue;
using Farakonesh.Logic.Services.RestRequest;
using Farakonesh.Logic.Services.App.Queue;
using Farakonesh.Logic.IServices.IApp.IQueue;
using Farakonesh.Logic.IServices.IApp.IPPG;

namespace Farakonesh.IOC
{
    public class ServiceIOC
    {
        public static void Configure(IServiceCollection services)
        {
            services.AddScoped<IAuthServices, AuthServices>();
            services.AddScoped<IInboxService, InboxService>();
            services.AddScoped<ITicketService, TicketService>();
            services.AddScoped<IPayeerService, PayeerService>();
            services.AddScoped<IUserServices, UserServices>();
            services.AddScoped<IOrderService, OrderService>();
            services.AddScoped<IAutoVerifyService, AutoVerifyService>();
            services.AddScoped<IJibitService, JibitService>();
            services.AddScoped<IShepaService, ShepaService>();
            services.AddScoped<IZarinpalService, ZarinpalService>();
            services.AddScoped<IVandarService, VandarService>();
            services.AddScoped<IPremiumAccountService, PremiumAccountService>();
            services.AddScoped<IAlarmOrderService, AlarmOrderService>();
            services.AddScoped<IAutomaticOrderOperationService, AutomaticOrderOperationService>();
            services.AddScoped<IOrderServicesWallet, OrderServicesWallet>();
            services.AddScoped<IWalletService, WalletService>();
            services.AddScoped<IPointWalletService, PointWalletService>();
            services.AddScoped<IUserVerifyService, UserVerifyService>();
            services.AddScoped<IChatService, ChatService>();
            services.AddScoped<IBankAccountService, BankAccountService>();
            services.AddScoped<IHttpRequestCaptcha, HttpRequestCaptcha>();
            services.AddScoped<IHttpRequestEmail, HttpRequestEmail>();
            services.AddScoped<IHttpRequestGeoLocation, HttpRequestGeoLocation>();
            services.AddScoped<IHttpRequestGoftino, HttpRequestGoftino>();
            services.AddScoped<IHttpRequestImage, HttpRequestImage>();
            services.AddScoped<IHttpRequestJibit, HttpRequestJibit>();
            services.AddScoped<IHttpRequestJibitPPG, HttpRequestJibitPPG>();
            services.AddScoped<IHttpRequestOAuth, HttpRequestOAuth>();
            services.AddScoped<IHttpRequestPayeer, HttpRequestPayeer>();
            services.AddScoped<IHttpRequestShepaPPG, HttpRequestShepaPPG>();
            services.AddScoped<IHttpRequestVandarPPG, HttpRequestVandarPPG>();
            services.AddScoped<IHttpRequestNipoto, HttpRequestNipoto>();
            services.AddScoped<IHttpRequestArvanCloud, HttpRequestArvanCloud>();
            services.AddScoped<IHttpRequestZarinpalPPG, HttpRequestZarinpalPPG>();
            services.AddScoped<IHttpRequestCrawler, HttpRequestCrawler>();
            services.AddScoped<IHttpRequestTelegram, HttpRequestTelegram>();
            services.AddScoped<ISmsService, SmsService>();
            services.AddScoped<IFileService, FileService>();
            services.AddScoped<ISendCurrencyWareHouseQueue, SendCurrencyWareHouseQueue>();
            services.AddScoped<ISendEmailQueue, SendEmailQueue>();
            services.AddScoped<ISendSMSQueue, SendSMSQueue>();
            services.AddScoped<ISendTelegramQueue, SendTelegramQueue>();
            services.AddScoped<ISendWhatsappQueue, SendWhatsappQueue>();
            services.AddSingleton<ITokenGenerator, TokenGenerator>();
            services.AddSingleton<ITokenUserService, TokenUserService>();
            services.AddScoped<ICompanyServices, CompanyServices>();
            services.AddScoped<IBalanceSystems, BalanceSystems>();
            services.AddScoped<IDasboardService, DasboardService>();
            services.AddScoped<INipotoService, NipotoService>();
            services.AddScoped<IZarinLinkService, ZarinLinkService>();
            services.AddScoped<IHttpRequestKavenegar, HttpRequestKavenegar>();
            services.AddScoped<IHttpRequestZarinLink, HttpRequestZarinLink>();
            services.AddScoped<IHttpRequestWhatsapp, HttpRequestWhatsapp>();
            services.AddScoped<IHttpRequestSmsIr, HttpRequestSmsIr>();
            services.AddScoped<ICalendarService, CalendarService>();
            services.AddScoped<IHttpRequestCalendarPnldev, HttpRequestCalendarPnldev>();
            services.AddScoped<IRedisContextService, RedisContextService>();
            services.AddScoped<IQueueMessengersService, QueueMessengersService>();
            services.AddScoped<ISendTTsQueue, SendTTsQueue>();
            services.AddScoped<IHttpRequestMediana, HttpRequestMediana>();
            services.AddScoped<IHttpRequestSepalPPG, HttpRequestSepalPPG>();
            services.AddScoped<ISepalService, SepalService>();
            services.AddScoped<IAccountNumberService, AccountNumberService>();
            services.AddScoped<IHttpRequestAnalytics, HttpRequestAnalytics>();
            services.AddScoped<IAddressService, AddressService>();
            services.AddScoped<IServiceKeysService, ServiceKeysService>();
        }
    }
}
