﻿using Farakonesh.Logic.Log;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Security.Cryptography;
using System.Text;

namespace Farakonesh.Logic.CommonOperations
{
    public class CryptoHelper
    {
        private readonly byte[] _aesKey;
        public CryptoHelper()
        {
        }
        public CryptoHelper(string aesKeyBase64)
        {
            _aesKey = Convert.FromBase64String(aesKeyBase64);
        }
        public string DecryptApiKey(byte[] encryptedApiKey, byte[] iv)
        {
            if (encryptedApiKey == null ||  iv == null)
            {
                return null;
            }
            using var aes = Aes.Create();
            aes.Key = _aesKey;
            aes.IV = iv;
            aes.Mode = CipherMode.CBC;
            aes.Padding = PaddingMode.PKCS7;

            using var decryptor = aes.CreateDecryptor(aes.Key, aes.IV);
            var decryptedBytes = decryptor.TransformFinalBlock(encryptedApiKey, 0, encryptedApiKey.Length);

            return Encoding.UTF8.GetString(decryptedBytes);
        }
        public byte[] ComputeHash(string value)
        {
            using var sha = SHA256.Create();
            return sha.ComputeHash(Encoding.UTF8.GetBytes(value));
        }

        public bool ValidateHash(string plainApiKey, byte[] storedHash)
        {
            var newHash = ComputeHash(plainApiKey);
            return storedHash.SequenceEqual(newHash);
        }
        public (byte[] encryptedData, byte[] iv, byte[] hash) EncryptApiKey(string plainApiKey)
        {
            if(string.IsNullOrWhiteSpace(plainApiKey))
            {
                return (null, null, null);
            }
            using var aes = Aes.Create();
            aes.Key = _aesKey;
            aes.Mode = CipherMode.CBC;
            aes.Padding = PaddingMode.PKCS7;

            aes.GenerateIV();

            using var encryptor = aes.CreateEncryptor(aes.Key, aes.IV);
            var plainBytes = Encoding.UTF8.GetBytes(plainApiKey);
            var encryptedBytes = encryptor.TransformFinalBlock(plainBytes, 0, plainBytes.Length);

            using var sha = SHA256.Create();
            var hash = sha.ComputeHash(plainBytes);

            return (encryptedBytes, aes.IV, hash);
        }
        public string signSHA256(string stringToBeSigned, string encodedPrivateKey)
        {
            string signedData = string.Empty;
            var decodeKey = Convert.FromBase64String(encodedPrivateKey);
            var key = CngKey.Import(decodeKey, CngKeyBlobFormat.Pkcs8PrivateBlob);
            var alg = new RSACng(key);
            byte[] data = Encoding.UTF8.GetBytes(stringToBeSigned);
            byte[] signData = alg.SignData(data, HashAlgorithmName.SHA256, RSASignaturePadding.Pkcs1);
            signedData = Convert.ToBase64String(signData);

            return signedData;
        }
    }
}
