﻿using Microsoft.AspNetCore.Http;
using System;
using System.Collections.Generic;
using System.IO;
using System.Text;
using System.Threading.Tasks;

namespace Farakonesh.Logic.CommonOperations
{
	public class FileHelper
	{
		public static async Task<byte[]> GetByteArrayFromImage(IFormFile file)
		{
			using (var target = new MemoryStream())
			{
				await file.CopyToAsync(target);
				return target.ToArray();
			}
		}
        public static bool hasImageExtension(string source)
        {
            return (source.EndsWith(".png") || source.EndsWith(".jpg") || source.EndsWith(".jpeg")
                || source.EndsWith(".JPG") || source.EndsWith(".PNG") || source.EndsWith(".JPEG") || source.EndsWith(".bmp")
                || source.EndsWith(".BMP") || source.EndsWith(".gif") || source.EndsWith(".GIF") || source.EndsWith(".jfif"));
        }

        public static bool hasFileOkExtension(string source)
        {
            return (source.EndsWith(".png") || source.EndsWith(".jpg") || source.EndsWith(".jpeg")
                || source.EndsWith(".JPG") || source.EndsWith(".PNG") || source.EndsWith(".JPEG") || source.EndsWith(".bmp")
                || source.EndsWith(".BMP") || source.EndsWith(".gif") || source.EndsWith(".GIF")
                || source.EndsWith(".PDF") || source.EndsWith(".pdf") || source.EndsWith(".jfif"));
        }
    }
}
