﻿using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using Farakonesh.Shared.Exceptions;
using System;
using System.Collections.Generic;
using System.Text;
using StackExchange.Redis;

namespace Farakonesh.Logic.CommonOperations
{
    /// <summary>
    /// Implementing convert object to json and json to object operations
    /// </summary>
    public static class JSON
    {
        /// <summary>
        /// تبدیل دیتای جیسون به آبجکت
        /// </summary>
        /// <typeparam name="T"></typeparam>
        /// <param name="json"></param>
        /// <returns></returns>
        public static T JsonToT<T>(this string json)
        {
            if (string.IsNullOrWhiteSpace(json))
                throw new RequestException("داده ای برای تبدیل یافت نشد");
            var rst = JsonConvert.DeserializeObject<T>(json);
            return (rst);
        }
        public static T JsonToT<T>(this RedisValue json)
        {
            if (string.IsNullOrWhiteSpace(json))
                throw new RequestException("داده ای برای تبدیل یافت نشد");
            var rst = JsonConvert.DeserializeObject<T>(json);
            return (rst);
        }

        public static JObject JsonParse(this string json)
        {
            if (string.IsNullOrWhiteSpace(json))
                throw new RequestException("داده ای برای تبدیل یافت نشد");
            JObject result = JObject.Parse(json);
            return (result);
        }

        /// <summary>
        /// تبدیل آبجکت به دیتای جیسون
        /// </summary>
        /// <param name="data"></param>
        /// <returns></returns>
        public static string ObjToJson(this object data)
        {
            if (data == null)
                return null;

            var rst = JsonConvert.SerializeObject(data);
            return rst;
        }

        public static bool IsValidJson(this string strInput)
        {
            if (string.IsNullOrWhiteSpace(strInput)) { return false; }
            strInput = strInput.Trim();
            if ((strInput.StartsWith("{") && strInput.EndsWith("}")) ||
                (strInput.StartsWith("[") && strInput.EndsWith("]")))
            {
                try
                {
                    var obj = JToken.Parse(strInput);
                    return true;
                }
                catch (JsonReaderException jex)
                {
                    return false;
                }
                catch (Exception ex)
                {
                    return false;
                }
            }
            else
            {
                return false;
            }
        }
    }
}
