﻿using Farakonesh.Logic.IDatabase.IUser;
using Farakonesh.Models.API.JibitInquiry;
using Farakonesh.Models.API.JibitOnlinePay;
using Farakonesh.Models.Database.StoredProcedures.App.User.User;
using Farakonesh.Shared.Enums;
using Farakonesh.Shared.Exceptions;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.CommonOperations
{
    public static class JibitErrorHandler
    {
        public static void handlerRequestPPG(this ResponsePurchasesJibitPPG response, bool isCheckedToken)
        {
            if (response == null)
            {
                throw new ExternalServiceException("خطا در اتصال به درگاه پرداخت ، در صورت تکرار خطا با کارشناسان ما ارتباط برقرار کنید");
            }
            if (response.errors != null && response.errors.Count > 0 && response.errors[0].code == "server.error")
                throw new ExternalServiceException("درگاه پرداخت دچاراختلال و قطعی می باشد ، لطفا چند لحظه دیگر مجددا تلاش بفرمایید ، در صورت تکرار خطا مراتب را به پشتیبانی سیستم اطلاع دهید");

            if (response.errors != null && response.errors.Count > 0 && response.errors[0].code == "clientReferenceNumber.duplicated")
                throw new ExternalServiceException("شناسه کلاینت وارد شده تکراری است ، در صورت تکرار خطا مراتب را به پشتیبانی سیستم اطلاع دهید");

            if (response.errors != null && response.errors.Count > 0 && (response.errors[0].code == "amount.not_enough" || response.errors[0].code == "amount_plus_wage.max_value_exceeded"))
                throw new ExternalServiceException("مبلغ پرداختی غیر مجاز می باشد");
            if (isCheckedToken && response.errors != null && response.errors.Count > 0)
            {
                throw new ExternalServiceException("خطا در ارسال درخواست به درگاه آنلاین ، در صورت تکرار خطا مراتب را به پشتیبانی سیستم اطلاع دهید");
            }
        }
        public static async Task handlerIdenticator(this ResponseRegisteryOfficeJibit response, bool isCheckedToken, string token, IUserContext _context, CancellationToken cancellationToken)
        {
            string error = "";
            if (response == null)
            {
                error = ("خطا در دریافت نتیجه استعلام اطلاعات ، لطفا دقایقی دیگر مجددا تلاش بفرمایید در صورت تکرار خطا مراتب را به پشتیبانی سیستم اطلاع بدهید");
            }
            if (!string.IsNullOrWhiteSpace(response.code) && response.code == "forbidden" && isCheckedToken)
            {
                error = ("باعرض پوزش ، در حال حاضر سرویس استعلام اطلاعات هویتی غیر فعال می باشد ، لطفا دقایقی دیگر مجددا تلاش بفرمایید ، درصورت تکرار خطا مراتب را به پشتیبانی سیستم اطلاع دهید");
            }
            if (!string.IsNullOrWhiteSpace(response.code) && response.code != "forbidden")
            {
                switch (response.code)
                {
                    case "providers.not_available":
                        error = ("باعرض پوزش ، در حال حاضر سرویس استعلام اطلاعات هویتی غیر فعال می باشد ، لطفا دقایقی دیگر مجددا تلاش بفرمایید ، درصورت تکرار خطا مراتب را به پشتیبانی سیستم اطلاع دهید");
                        break;
                    case "server.error":
                        error = ("خطا در سرویس استعلام اطلاعات هویتی ، لطفا دقایقی دیگر مجددا تلاش بفرمایید ، درصورت تکرار خطا مراتب را به پشتیبانی سیستم اطلاع دهید");
                        break;
                    case "daily_limit.reached":
                        error = ("محدودیت در فراخوانی سرویس اطلاعات هویتی ، لطفا دقایقی دیگر مجددا تلاش بفرمایید ، درصورت تکرار خطا مراتب را به پشتیبانی سیستم اطلاع دهید");
                        break;
                    case "identity_info.not_found":
                        error = ("عدم تطبیق کد ملی با اطلاعات وارد شده ، در صورت تکرار خطا مراتب را به پشتیبانی سیستم اطلاع دهید");
                        break;
                    default:
                        error = (response.message);
                        break;
                }
            }
            if (string.IsNullOrWhiteSpace(response.code))
            {
                if (response.firstNameSimilarityPercentage < 50)
                    error = ("خطا در احراز هویت ، بنظر می آید نام را اشتباه وارد نموده اید");

                if (response.lastNameSimilarityPercentage < 50)
                    error = ("خطا در احراز هویت ، بنظر می آید نام خانوادگی را اشتباه وارد نموده اید");
            }
            if (!string.IsNullOrWhiteSpace(error))
            {
                await _context.Insert_WrongInquiry(new Insert_WrongInquiry.Inputs
                {
                    Token = token,
                    Type = (int)TypeWrongAction.UnsuccessfulInquiryCivilRegistry
                }, cancellationToken);
                throw new ExternalServiceException(error);
            }
        }

        public static async Task handlerInquiryMatched(this ResponseMatchJibit response, bool isCheckedToken,
            string token,IUserContext _context, CancellationToken cancellationToken)
        {
            string error = "";
            if (response == null)
            {
                error = ("خطا در دریافت نتیجه استعلام از بانک ، لطفا دقایقی دیگر مجددا تلاش بفرمایید در صورت تکرار خطا مراتب را به پشتیبانی سیستم اطلاع بدهید");
            }

            if (!string.IsNullOrWhiteSpace(response.code) && response.code == "forbidden" && isCheckedToken)
            {
                error = ("باعرض پوزش ، در حال حاضر سرویس استعلام از بانک غیر فعال می باشد ، لطفا دقایقی دیگر مجددا تلاش بفرمایید ، درصورت تکرار خطا مراتب را به پشتیبانی سیستم اطلاع دهید");
            }
            if (!string.IsNullOrWhiteSpace(response.code) && response.code != "forbidden")
            {
                switch (response.code)
                {
                    case "providers.not_available":
                        error = ("باعرض پوزش ، در حال حاضر سرویس استعلام از بانک غیر فعال می باشد ، لطفا دقایقی دیگر مجددا تلاش بفرمایید ، درصورت تکرار خطا مراتب را به پشتیبانی سیستم اطلاع دهید");
                        break;
                    case "server.error":
                        error = ("خطا در سرویس استعلام از بانک ، لطفا دقایقی دیگر مجددا تلاش بفرمایید ، درصورت تکرار خطا مراتب را به پشتیبانی سیستم اطلاع دهید");
                        break;
                    case "daily_limit.reached":
                        error = ("محدودیت در فراخوانی سرویس استعلام از بانک ، لطفا دقایقی دیگر مجددا تلاش بفرمایید ، درصورت تکرار خطا مراتب را به پشتیبانی سیستم اطلاع دهید");
                        break;
                    case "card.not_valid":
                        error = ("کارت بانکی نامعتبر است ، لطفا از کارت بانکی دیگری استفاده نمایید ، در صورت تکرار خطا مراتب را به پشتیبانی سیستم اطلاع دهید");
                        break;
                    case "card.not_active":
                        error = ("کارت بانکی غیرفعال است ، لطفا از کارت بانکی دیگری استفاده نمایید ، در صورت تکرار خطا مراتب را به پشتیبانی سیستم اطلاع دهید");
                        break;
                    case "card.account_number_not_valid":
                        error = ("شماره حساب مربوط به کارت بانکی معتبر نیست ، لطفا از کارت بانکی دیگری استفاده نمایید ، در صورت تکرار خطا مراتب را به پشتیبانی سیستم اطلاع دهید");
                        break;
                    case "card.owner_not_authorized":
                        error = ("هویت دارنده کارت نامعتبر است ، لطفا از کارت بانکی دیگری استفاده نمایید ، در صورت تکرار خطا مراتب را به پشتیبانی سیستم اطلاع دهید");
                        break;
                    case "card.registered_as_lost":
                        error = ("این کارت به عنوان کارت گم شده ثبت شده است ، لطفا از کارت بانکی دیگری استفاده نمایید ، در صورت تکرار خطا مراتب را به پشتیبانی سیستم اطلاع دهید");
                        break;
                    case "card.registered_as_stolen":
                        error = ("این کارت به عنوان کارت مسروقه ثبت شده است ، لطفا از کارت بانکی دیگری استفاده نمایید ، در صورت تکرار خطا مراتب را به پشتیبانی سیستم اطلاع دهید");
                        break;
                    case "card.is_expired":
                        error = ("این کارت منقضی شده است ، لطفا از کارت بانکی دیگری استفاده نمایید ، در صورت تکرار خطا مراتب را به پشتیبانی سیستم اطلاع دهید");
                        break;
                    case "card.source_bank_is_not_active":
                        error = ("بانک مربوط به کارت غیرفعال است ، لطفا از کارت بانکی دیگری استفاده نمایید ، در صورت تکرار خطا مراتب را به پشتیبانی سیستم اطلاع دهید");
                        break;
                    case "card.black_listed":
                        error = ("استعلام این کارت امکان پذیر نیست ، لطفا از کارت بانکی دیگری استفاده نمایید ، در صورت تکرار خطا مراتب را به پشتیبانی سیستم اطلاع دهید");
                        break;
                    case "dentity_info.not_found":
                        error = ("اطلاعات هویتی برای این کارت بانکی یافت نشد ، لطفا از کارت بانکی دیگری استفاده نمایید ، در صورت تکرار خطا مراتب را به پشتیبانی سیستم اطلاع دهید");
                        break;
                    case "matching.unknown":
                        error = ("تطابق کارت بانکی نامشخص است ، لطفا از کارت بانکی دیگری استفاده نمایید ، در صورت تکرار خطا مراتب را به پشتیبانی سیستم اطلاع دهید");
                        break;
                    case "card.provider_is_not_active":
                        error = ("سرویس دهنده مربوط به کارت فعال نیست ، لطفا از کارت بانکی دیگری استفاده نمایید ، در صورت تکرار خطا مراتب را به پشتیبانی سیستم اطلاع دهید");
                        break;
                    default:
                        error = (response.message);
                        break;
                }
            }
            if (string.IsNullOrWhiteSpace(response.code) && response.matched == false)
            {
                error = "شماره کارت بانکی ، متعلق به کد ملی ارسال شده نیست";
            }
            if (!string.IsNullOrWhiteSpace(error))
            {
                await _context.Insert_WrongInquiry(new Insert_WrongInquiry.Inputs
                {
                    Token = token,
                    Type = (int)TypeWrongAction.UnsuccessfulInquiryCentralBank
                }, cancellationToken);
                throw new ExternalServiceException(error);
            }
        }


        public static async Task handlerInquiryPostalCode(this ResponsePostalJibit response, bool isCheckedToken,
         string token, IUserContext _context, CancellationToken cancellationToken)
        {
            string error = "";
            if (response == null)
            {
                error = ("خطا در دریافت نتیجه استعلام از اداره پست ، لطفا دقایقی دیگر مجددا تلاش بفرمایید در صورت تکرار خطا مراتب را به پشتیبانی سیستم اطلاع بدهید");
            }

            if (!string.IsNullOrWhiteSpace(response.code) && response.code == "forbidden" && isCheckedToken)
            {
                error = ("باعرض پوزش ، در حال حاضر سرویس استعلام از اداره پست غیر فعال می باشد ، لطفا دقایقی دیگر مجددا تلاش بفرمایید ، درصورت تکرار خطا مراتب را به پشتیبانی سیستم اطلاع دهید");
            }
            if (!string.IsNullOrWhiteSpace(response.code) && response.code != "forbidden")
            {
                switch (response.code)
                {
                    case "providers.not_available":
                        error = ("باعرض پوزش ، در حال حاضر سرویس استعلام از اداره پست غیر فعال می باشد ، لطفا دقایقی دیگر مجددا تلاش بفرمایید ، درصورت تکرار خطا مراتب را به پشتیبانی سیستم اطلاع دهید");
                        break;
                    case "server.error":
                        error = ("خطا در سرویس استعلام از اداره پست ، لطفا دقایقی دیگر مجددا تلاش بفرمایید ، درصورت تکرار خطا مراتب را به پشتیبانی سیستم اطلاع دهید");
                        break;
                    case "daily_limit.reached":
                        error = ("محدودیت در فراخوانی سرویس استعلام از اداره پست ، لطفا دقایقی دیگر مجددا تلاش بفرمایید ، درصورت تکرار خطا مراتب را به پشتیبانی سیستم اطلاع دهید");
                        break;
                    case "postalCode.not_valid":
                        error = ("کد پستی نامعتبر است ، لطفا از کد پستی دیگری استفاده نمایید ، در صورت تکرار خطا مراتب را به پشتیبانی سیستم اطلاع دهید");
                        break;
                   
                    case "dentity_info.not_found":
                        error = ("اطلاعاتی  برای این کد پستی یافت نشد ، لطفا از کد پستی دیگری استفاده نمایید ، در صورت تکرار خطا مراتب را به پشتیبانی سیستم اطلاع دهید");
                        break;
                    default:
                        error = (response.message);
                        break;
                }
            }

            if (!string.IsNullOrWhiteSpace(error))
            {
                await _context.Insert_WrongInquiry(new Insert_WrongInquiry.Inputs
                {
                    Token = token,
                    Type = (int)TypeWrongAction.UnsuccessfulInquiryPostOffice
                }, cancellationToken);
                throw new InquiryPostalCodeException(error);
            }
        }

        public static async Task handlerInquiryMatchedShahkar(this ResponseMatchJibit response, bool isCheckedToken,
          string token, IUserContext _context, CancellationToken cancellationToken)
        {
            string error = "";
            if (response == null)
            {
                error = ("خطا در دریافت نتیجه استعلام از شبکه احراز ، لطفا دقایقی دیگر مجددا تلاش بفرمایید در صورت تکرار خطا مراتب را به پشتیبانی سیستم اطلاع بدهید");
            }

            if (!string.IsNullOrWhiteSpace(response.code) && response.code == "forbidden" && isCheckedToken)
            {
                error = ("باعرض پوزش ، در حال حاضر شبکه احراز غیر فعال می باشد ، لطفا دقایقی دیگر مجددا تلاش بفرمایید ، درصورت تکرار خطا مراتب را به پشتیبانی سیستم اطلاع دهید");
            }
            if (!string.IsNullOrWhiteSpace(response.code) && response.code != "forbidden")
            {
                switch (response.code)
                {
                    case "providers.not_available":
                        error = ("باعرض پوزش ، در حال حاضر شبکه احراز غیر فعال می باشد ، لطفا دقایقی دیگر مجددا تلاش بفرمایید ، درصورت تکرار خطا مراتب را به پشتیبانی سیستم اطلاع دهید");
                        break;
                    case "server.error":
                        error = ("خطا در شبکه احراز ، لطفا دقایقی دیگر مجددا تلاش بفرمایید ، درصورت تکرار خطا مراتب را به پشتیبانی سیستم اطلاع دهید");
                        break;
                    case "daily_limit.reached":
                        error = ("محدودیت در فراخوانی شبکه احراز ، لطفا دقایقی دیگر مجددا تلاش بفرمایید ، درصورت تکرار خطا مراتب را به پشتیبانی سیستم اطلاع دهید");
                        break;
                    case "mobileNumber.not_valid":
                        error = ("شماره موبایل نامعتبر است ، لطفا شماره موبایل صحیح را وارد کنید ، در صورت تکرار خطا مراتب را به پشتیبانی سیستم اطلاع دهید");
                        break;
                    case "nationalCode.not_valid":
                        error = ("کد ملی نامعتبر است ، لطفا کد ملی صحیح را وارد کنید ، در صورت تکرار خطا مراتب را به پشتیبانی سیستم اطلاع دهید");
                        break;

                    case "matching.unknown":
                        error = ("تطابق شاهکار نامشخص است ، در صورت تکرار خطا مراتب را به پشتیبانی سیستم اطلاع دهید");
                        break;
                    default:
                        error = (response.message);
                        break;
                }
            }
            if (string.IsNullOrWhiteSpace(response.code) && response.matched == false)
            {
                error = "شماره همراه ، متعلق به کد ملی ارسال شده نیست";
            }
            if (!string.IsNullOrWhiteSpace(error))
            {
                await _context.Insert_WrongInquiry(new Insert_WrongInquiry.Inputs
                {
                    Token = token,
                    Type = (int)TypeWrongAction.UnsuccessfulInquiryShahkar
                }, cancellationToken);
                throw new ExternalServiceException(error);
            }
        }

        public static async Task handlerGetBanckAccountInfo(this ResponseConvertToShebaJibit response, bool isCheckedToken, string token, IUserContext _context, CancellationToken cancellationToken)
        {
            string error = "";
            if (response == null)
            {
                error = ("خطا در دریافت نتیجه اطلاعات از بانک ، لطفا دقایقی دیگر مجددا تلاش بفرمایید در صورت تکرار خطا مراتب را به پشتیبانی سیستم اطلاع بدهید");
            }

            if (!string.IsNullOrWhiteSpace(response.code) && response.code == "forbidden" && isCheckedToken)
            {
                error = ("باعرض پوزش ، در حال حاضر سرویس استعلام از بانک غیر فعال می باشد ، لطفا دقایقی دیگر مجددا تلاش بفرمایید ، درصورت تکرار خطا مراتب را به پشتیبانی سیستم اطلاع دهید");
            }
            if (!string.IsNullOrWhiteSpace(response.code) && response.code != "forbidden")
            {
                switch (response.code)
                {
                    case "providers.not_available":
                        error = ("باعرض پوزش ، در حال حاضر سرویس استعلام از بانک غیر فعال می باشد ، لطفا دقایقی دیگر مجددا تلاش بفرمایید ، درصورت تکرار خطا مراتب را به پشتیبانی سیستم اطلاع دهید");
                        break;
                    case "server.error":
                        error = ("خطا در سرویس استعلام از بانک ، لطفا دقایقی دیگر مجددا تلاش بفرمایید ، درصورت تکرار خطا مراتب را به پشتیبانی سیستم اطلاع دهید");
                        break;
                    case "daily_limit.reached":
                        error = ("محدودیت در فراخوانی سرویس استعلام از بانک ، لطفا دقایقی دیگر مجددا تلاش بفرمایید ، درصورت تکرار خطا مراتب را به پشتیبانی سیستم اطلاع دهید");
                        break;
                    case "card.not_valid":
                        error = ("کارت بانکی نامعتبر است ، لطفا از کارت بانکی دیگری استفاده نمایید ، در صورت تکرار خطا مراتب را به پشتیبانی سیستم اطلاع دهید");
                        break;
                    case "card.not_active":
                        error = ("کارت بانکی غیرفعال است ، لطفا از کارت بانکی دیگری استفاده نمایید ، در صورت تکرار خطا مراتب را به پشتیبانی سیستم اطلاع دهید");
                        break;
                    case "card.account_number_not_valid":
                        error = ("شماره حساب مربوط به کارت بانکی معتبر نیست ، لطفا از کارت بانکی دیگری استفاده نمایید ، در صورت تکرار خطا مراتب را به پشتیبانی سیستم اطلاع دهید");
                        break;
                    case "card.owner_not_authorized":
                        error = ("هویت دارنده کارت نامعتبر است ، لطفا از کارت بانکی دیگری استفاده نمایید ، در صورت تکرار خطا مراتب را به پشتیبانی سیستم اطلاع دهید");
                        break;
                    case "card.registered_as_lost":
                        error = ("این کارت به عنوان کارت گم شده ثبت شده است ، لطفا از کارت بانکی دیگری استفاده نمایید ، در صورت تکرار خطا مراتب را به پشتیبانی سیستم اطلاع دهید");
                        break;
                    case "card.registered_as_stolen":
                        error = ("این کارت به عنوان کارت مسروقه ثبت شده است ، لطفا از کارت بانکی دیگری استفاده نمایید ، در صورت تکرار خطا مراتب را به پشتیبانی سیستم اطلاع دهید");
                        break;
                    case "card.is_expired":
                        error = ("این کارت منقضی شده است ، لطفا از کارت بانکی دیگری استفاده نمایید ، در صورت تکرار خطا مراتب را به پشتیبانی سیستم اطلاع دهید");
                        break;
                    case "card.source_bank_is_not_active":
                        error = ("بانک مربوط به کارت غیرفعال است ، لطفا از کارت بانکی دیگری استفاده نمایید ، در صورت تکرار خطا مراتب را به پشتیبانی سیستم اطلاع دهید");
                        break;
                    case "card.black_listed":
                        error = ("استعلام این کارت امکان پذیر نیست ، لطفا از کارت بانکی دیگری استفاده نمایید ، در صورت تکرار خطا مراتب را به پشتیبانی سیستم اطلاع دهید");
                        break;
                    case "dentity_info.not_found":
                        error = ("اطلاعات هویتی برای این کارت بانکی یافت نشد ، لطفا از کارت بانکی دیگری استفاده نمایید ، در صورت تکرار خطا مراتب را به پشتیبانی سیستم اطلاع دهید");
                        break;
                    case "card.provider_is_not_active":
                        error = ("سرویس دهنده مربوط به کارت فعال نیست ، لطفا از کارت بانکی دیگری استفاده نمایید ، در صورت تکرار خطا مراتب را به پشتیبانی سیستم اطلاع دهید");
                        break;
                    default:
                        error = (response.message);
                        break;
                }
            }
            if (string.IsNullOrWhiteSpace(response.code) && response.ibanInfo == null)
            {
                error = ("خطا در دریافت اطلاعات کارت بانکی ، در صورت تکرار خطا مراتب را پشتیبانی برنامه اطلاع دهید");
            }
            if (string.IsNullOrWhiteSpace(response.code) && response.ibanInfo.status != "ACTIVE")
            {
                error = ("لطفا یک حساب بانکی فعال وارد نمایید");
            }
            if (!string.IsNullOrWhiteSpace(error))
            {
                await _context.Insert_WrongInquiry(new Insert_WrongInquiry.Inputs
                {
                    Token = token,
                    Type = (int)TypeWrongAction.UnsuccessfulInquiryCentralBank
                }, cancellationToken);
                throw new ExternalServiceException(error);
            }
        }
    }
}
