﻿using Microsoft.Extensions.Configuration;
using Farakonesh.Logic.Database.dbo;
using Farakonesh.Logic.ICommonOperations;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.IServices.ICache;
using Farakonesh.Logic.Services.Cache;
using Farakonesh.Models.API.Captcha;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.setting;
using System;
using System.Collections.Generic;
using System.Net;
using System.Net.Http;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using Farakonesh.Shared.Exceptions;
using Farakonesh.Shared.Enums;

namespace Farakonesh.Logic.CommonOperations
{
    public class ReCaptchaHelper : IReCaptchaHelper
    {
        private readonly IHttpClientFactory _httpClientFactory;
        private readonly IRedisContextService _redisContextService;
        public ReCaptchaHelper(IHttpClientFactory httpClientFactory, IRedisContextService redisContextService)
        {
            _httpClientFactory = httpClientFactory;
            _redisContextService = redisContextService;
        }
        public async Task<bool> validate(string encodedResponse, CancellationToken cancellationToken)
        {
            var setting = await _redisContextService.GetWebserviceAsync(WebServiceType.GoogleRecaptcha,cancellationToken);

            if(string.IsNullOrWhiteSpace(encodedResponse))
            {
                throw new LogicalException("امضا کپچا ارسال نشده ، لطفا مجددا درخواست را ارسال کنید");
            }

            Uri url = new Uri(string.Format(setting.BaseUrlService + "?secret={0}&response={1}", setting.RealApiKey, encodedResponse));
            var _client = _httpClientFactory.CreateClient();
            var googleReply = await _client.GetStringAsync(url);

            var captchaResponse = Newtonsoft.Json.JsonConvert.DeserializeObject<ResponseRecaptcha>(googleReply);

            return captchaResponse.Success;

        }
    }
}
